/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.infrastructure.process;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.Executor;
import org.apache.commons.exec.PumpStreamHandler;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.test.infrastructure.process.AbstractOSController;
import org.mule.test.infrastructure.process.MuleControllerException;

public class UnixController
extends AbstractOSController {
    public UnixController(String muleHome, int timeout) {
        super(muleHome, timeout);
    }

    @Override
    public String getMuleBin() {
        return this.muleHome + "/bin/mule";
    }

    @Override
    protected String getAmcSetupBin() {
        return this.muleHome + "/bin/amc_setup";
    }

    @Override
    public int getProcessId() {
        Map<String, String> newEnv = this.copyEnvironmentVariables();
        DefaultExecutor executor = new DefaultExecutor();
        ExecuteWatchdog watchdog = new ExecuteWatchdog((long)this.timeout);
        executor.setWatchdog(watchdog);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PumpStreamHandler streamHandler = new PumpStreamHandler((OutputStream)outputStream);
        executor.setStreamHandler((ExecuteStreamHandler)streamHandler);
        if (this.doExecution((Executor)executor, new CommandLine(this.muleBin).addArgument("status"), newEnv) == 0) {
            Matcher matcher = STATUS_LABELS_PATTERN.matcher(outputStream.toString());
            if (matcher.find() && !StringUtils.isEmpty((String)matcher.group("pid"))) {
                return Integer.parseInt(matcher.group("pid"));
            }
            throw new MuleControllerException("bin/mule status didn't return the expected pattern: " + STATUS_LABELS);
        }
        throw new MuleControllerException("Mule Runtime is not running");
    }

    @Override
    public AbstractOSController.MuleProcessStatus getProcessesStatus() {
        Map<String, String> newEnv = this.copyEnvironmentVariables();
        DefaultExecutor executor = new DefaultExecutor();
        ExecuteWatchdog watchdog = new ExecuteWatchdog((long)this.timeout);
        executor.setWatchdog(watchdog);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PumpStreamHandler streamHandler = new PumpStreamHandler((OutputStream)outputStream);
        executor.setStreamHandler((ExecuteStreamHandler)streamHandler);
        if (this.doExecution((Executor)executor, new CommandLine(this.muleBin).addArgument("status"), newEnv) == 0) {
            Matcher matcher = STATUS_LABELS_PATTERN.matcher(outputStream.toString());
            if (matcher.find() && !StringUtils.isEmpty((String)matcher.group("wrapper")) && !StringUtils.isEmpty((String)matcher.group("java"))) {
                return AbstractOSController.MuleProcessStatus.valueOf(String.format("%s_%s", matcher.group("wrapper"), matcher.group("java")));
            }
            throw new MuleControllerException("bin/mule status didn't return the expected pattern: " + STATUS_LABELS);
        }
        throw new MuleControllerException("Mule Runtime is not running");
    }

    @Override
    public int status(String ... args) {
        return this.runSync("status", args);
    }
}

