/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.infrastructure.deployment;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import org.junit.rules.ExternalResource;
import org.junit.rules.TemporaryFolder;
import org.mule.functional.services.TestServicesUtils;

public final class TestArtifactsCatalog
extends ExternalResource {
    public static File schedulerServiceJarFile;
    public static File httpServiceJarFile;
    public static File expressionLanguageServiceJarFile;
    public static File expressionLanguageMetadataServiceJarFile;
    private static TemporaryFolder compilerWorkFolder;

    public TestArtifactsCatalog(TemporaryFolder compilerWorkFolder) {
        TestArtifactsCatalog.compilerWorkFolder = compilerWorkFolder;
    }

    protected void before() throws Throwable {
        super.before();
        if (schedulerServiceJarFile != null) {
            return;
        }
        try {
            TestArtifactsCatalog.initFiles();
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private static void initFiles() throws URISyntaxException, IOException {
        httpServiceJarFile = TestServicesUtils.buildHttpServiceFile((File)compilerWorkFolder.newFolder("httpService"));
        schedulerServiceJarFile = TestServicesUtils.buildSchedulerServiceFile((File)compilerWorkFolder.newFolder("schedulerService"));
        expressionLanguageServiceJarFile = TestServicesUtils.buildExpressionLanguageServiceFile((File)compilerWorkFolder.newFolder("expressionLanguageService"));
        expressionLanguageMetadataServiceJarFile = TestServicesUtils.buildExpressionLanguageMetadataServiceFile((File)compilerWorkFolder.newFolder("expressionLanguageMetadataService"));
    }
}

