/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.infrastructure.process;

import java.io.IOException;
import org.mule.tck.probe.Probe;
import org.mule.test.infrastructure.process.MuleProcessController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleStatusProbe
implements Probe {
    private static final Logger LOGGER = LoggerFactory.getLogger(MuleStatusProbe.class);
    private final MuleProcessController controller;
    private final boolean check;

    private MuleStatusProbe(MuleProcessController controller, boolean isRunning) {
        this.controller = controller;
        this.check = isRunning;
    }

    public boolean isSatisfied() {
        return this.check == this.controller.isRunning();
    }

    public String describeFailure() {
        try {
            this.controller.getController().printLog();
        }
        catch (IOException e) {
            LOGGER.error("Error printing log.", (Throwable)e);
        }
        return "Mule is " + (this.check ? "not " : "") + "running";
    }

    public static Probe isRunning(MuleProcessController controller) {
        return new MuleStatusProbe(controller, true);
    }

    public static Probe isNotRunning(MuleProcessController controller) {
        return new MuleStatusProbe(controller, false);
    }
}

