/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.infrastructure.process;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.PumpStreamHandler;
import org.mule.test.infrastructure.process.AbstractOSController;
import org.mule.test.infrastructure.process.MuleControllerException;

public class UnixController
extends AbstractOSController {
    public UnixController(String muleHome, int timeout) {
        super(muleHome, timeout);
    }

    @Override
    public String getMuleBin() {
        return this.muleHome + "/bin/mule";
    }

    @Override
    public int getProcessId() {
        Map<Object, Object> newEnv = this.copyEnvironmentVariables();
        DefaultExecutor executor = new DefaultExecutor();
        ExecuteWatchdog watchdog = new ExecuteWatchdog((long)this.timeout);
        executor.setWatchdog(watchdog);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PumpStreamHandler streamHandler = new PumpStreamHandler((OutputStream)outputStream);
        executor.setStreamHandler((ExecuteStreamHandler)streamHandler);
        if (this.doExecution(executor, new CommandLine(this.muleBin).addArgument("status"), newEnv) == 0) {
            Matcher matcher = STATUS_PATTERN.matcher(outputStream.toString());
            if (matcher.find()) {
                return Integer.parseInt(matcher.group(3));
            }
            throw new MuleControllerException("bin/mule status didn't return the expected pattern: Mule(\\sEnterprise Edition \\(standalone\\))? is running(\\s|:\\sPID:)?\\(?([0-9]+)\\)?.*");
        }
        throw new MuleControllerException("Mule Runtime is not running");
    }

    @Override
    public int status(String ... args) {
        return this.runSync("status", args);
    }
}

