/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.util.sftp;

import java.io.File;
import java.io.IOException;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.server.CommandFactory;
import org.apache.sshd.server.SshServer;
import org.apache.sshd.server.auth.password.PasswordAuthenticator;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;
import org.apache.sshd.server.scp.ScpCommandFactory;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.server.subsystem.sftp.SftpSubsystemFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class SftpServer {
    public static final String USERNAME = "muletest1";
    public static final String PASSWORD = "muletest1";
    private SshServer sshdServer;
    private Integer port;

    public SftpServer(int port) {
        this.port = port;
        this.configureSecurityProvider();
        SftpSubsystemFactory factory = this.createFtpSubsystemFactory();
        this.sshdServer = SshServer.setUpDefaultServer();
        this.configureSshdServer(factory, SftpServer.passwordAuthenticator());
    }

    public void setPasswordAuthenticator(PasswordAuthenticator passwordAuthenticator) {
        this.sshdServer.setPasswordAuthenticator(passwordAuthenticator);
    }

    private void configureSshdServer(SftpSubsystemFactory factory, PasswordAuthenticator passwordAuthenticator) {
        this.sshdServer.setPort(this.port.intValue());
        this.sshdServer.setKeyPairProvider((KeyPairProvider)new SimpleGeneratorHostKeyProvider(new File("hostkey.ser")));
        this.sshdServer.setSubsystemFactories(Arrays.asList(factory));
        this.sshdServer.setCommandFactory((CommandFactory)new ScpCommandFactory());
        this.sshdServer.setPasswordAuthenticator(passwordAuthenticator);
    }

    private SftpSubsystemFactory createFtpSubsystemFactory() {
        SftpSubsystemFactory factory = new SftpSubsystemFactory();
        return factory;
    }

    private void configureSecurityProvider() {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    private static PasswordAuthenticator passwordAuthenticator() {
        return new PasswordAuthenticator(){

            public boolean authenticate(String arg0, String arg1, ServerSession arg2) {
                return "muletest1".equals(arg0) && "muletest1".equals(arg1);
            }
        };
    }

    public void start() {
        try {
            this.sshdServer.start();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void stop() {
        try {
            this.sshdServer.stop(false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.sshdServer = null;
    }
}

