/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.util;

import java.util.concurrent.CountDownLatch;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.Assert;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.context.notification.FlowCallStack;
import org.mule.api.context.notification.FlowStackElement;
import org.mule.api.processor.MessageProcessor;

public class FlowTraceUtils {
    public static void assertStackElements(FlowCallStack flowStack, Matcher<FlowStackElement> ... flowStackElementMatchers) {
        Assert.assertThat((Object)flowStack.getElements(), (Matcher)IsCollectionWithSize.hasSize((int)flowStackElementMatchers.length));
        int i = 0;
        for (Matcher<FlowStackElement> flowStackElementMatcher : flowStackElementMatchers) {
            Assert.assertThat(flowStack.getElements().get(i), flowStackElementMatcher);
            ++i;
        }
    }

    public static Matcher<FlowStackElement> isFlowStackElement(final String flowName, final String executingMessageProcessor) {
        return new TypeSafeMatcher<FlowStackElement>(){

            protected boolean matchesSafely(FlowStackElement flowStackElement) {
                return flowStackElement.getFlowName().startsWith(flowName) && (executingMessageProcessor == null ? flowStackElement.getProcessorPath() == null : flowStackElement.getProcessorPath().startsWith(executingMessageProcessor + " @"));
            }

            public void describeTo(Description description) {
                if (executingMessageProcessor == null) {
                    description.appendText("<").appendText(flowName);
                } else {
                    description.appendText("<").appendText(flowName).appendText("(").appendText(executingMessageProcessor).appendText("*)");
                }
            }
        };
    }

    public static class FlowStackAsyncAsserter
    extends FlowStackAsserter {
        public static CountDownLatch latch;

        @Override
        public MuleEvent process(MuleEvent event) throws MuleException {
            super.process(event);
            latch.countDown();
            return event;
        }
    }

    public static class FlowStackAsserter
    implements MessageProcessor {
        public static FlowCallStack stackToAssert;

        public MuleEvent process(MuleEvent event) throws MuleException {
            stackToAssert = event.getFlowCallStack().clone();
            return event;
        }
    }
}

