/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.util;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.mule.tck.util.MuleDerbyTestUtils;

public class MuleDerbyTestDatabase {
    public static final String DERBY_PROPERTIES_FILE = "derby.properties";
    private final String databaseNameProperty;
    private String connectionString;

    public MuleDerbyTestDatabase(String databaseNameProperty) {
        this.databaseNameProperty = databaseNameProperty;
    }

    public void startDatabase() throws Exception {
        String dbName = MuleDerbyTestUtils.loadDatabaseName(DERBY_PROPERTIES_FILE, this.databaseNameProperty);
        MuleDerbyTestUtils.defaultDerbyCleanAndInit(DERBY_PROPERTIES_FILE, this.databaseNameProperty);
        this.connectionString = "jdbc:derby:" + dbName;
        this.emptyTestTable();
    }

    public void stopDatabase() throws SQLException {
        MuleDerbyTestUtils.stopDatabase();
    }

    public void emptyTestTable() throws Exception {
        try {
            this.execSqlUpdate("DELETE FROM TEST");
        }
        catch (Exception e) {
            this.execSqlUpdate("CREATE TABLE TEST(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY,DATA VARCHAR(255), TYPE NUMERIC, ACK NUMERIC)");
        }
    }

    public void insertIntoTest(String data, int type) {
        try {
            this.execSqlUpdate("INSERT into Test (data, type) VALUES ('" + data + "', " + type + ")");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Connection getConnection() throws Exception {
        Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
        return DriverManager.getConnection(this.connectionString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List execSqlQuery(String sql) throws Exception {
        Connection con = null;
        try {
            con = this.getConnection();
            List list = (List)new QueryRunner().query(con, sql, (ResultSetHandler)new ArrayListHandler());
            return list;
        }
        finally {
            if (con != null && !con.isClosed()) {
                con.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execSqlUpdate(String sql) throws Exception {
        Connection con = null;
        try {
            con = this.getConnection();
            int n = new QueryRunner().update(con, sql);
            return n;
        }
        finally {
            if (con != null && !con.isClosed()) {
                con.close();
            }
        }
    }
}

