/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.listener;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.mule.api.MuleContext;
import org.mule.api.context.notification.ExceptionNotificationListener;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.context.notification.ExceptionNotification;
import org.mule.context.notification.NotificationException;
import org.mule.util.concurrent.Latch;

public class ExceptionListener {
    private CountDownLatch exceptionThrownLatch = new Latch();
    private int timeout = 10000;

    public ExceptionListener(MuleContext muleContext) {
        try {
            muleContext.registerListener((ServerNotificationListener)new ExceptionNotificationListener<ExceptionNotification>(){

                public void onNotification(ExceptionNotification notification) {
                    ExceptionListener.this.exceptionThrownLatch.countDown();
                }
            });
        }
        catch (NotificationException e) {
            throw new RuntimeException(e);
        }
    }

    public void waitUntilAllNotificationsAreReceived() {
        try {
            if (!this.exceptionThrownLatch.await(this.timeout, TimeUnit.MILLISECONDS)) {
                Assert.fail((String)"An exception was never thrown");
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public ExceptionListener setNumberOfExecutionsRequired(int numberOfExecutionsRequired) {
        this.exceptionThrownLatch = new CountDownLatch(numberOfExecutionsRequired);
        return this;
    }

    public ExceptionListener setTimeoutInMillis(int timeout) {
        this.timeout = timeout;
        return this;
    }
}

