/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.junit4;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.After;
import org.junit.Before;
import org.mule.api.MuleContext;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.ApplicationContextBuilder;
import org.mule.tck.junit4.DomainContextBuilder;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;

public abstract class DomainFunctionalTestCase
extends AbstractMuleTestCase {
    private final Map<String, MuleContext> muleContexts = new HashMap<String, MuleContext>();
    private final List<MuleContext> disposedContexts = new ArrayList<MuleContext>();
    private MuleContext domainContext;

    protected abstract String getDomainConfig();

    public synchronized void disposeMuleContext(final MuleContext muleContext) {
        this.disposedContexts.add(muleContext);
        muleContext.dispose();
        new PollingProber(10000L, 100L).check(new Probe(){

            public boolean isSatisfied() {
                return muleContext.isDisposed();
            }

            public String describeFailure() {
                return "mule context timeout during dispose";
            }
        });
    }

    @Before
    public void setUpMuleContexts() throws Exception {
        ApplicationConfig[] applicationConfigs;
        this.domainContext = new DomainContextBuilder().setDomainConfig(this.getDomainConfig()).build();
        for (ApplicationConfig applicationConfig : applicationConfigs = this.getConfigResources()) {
            MuleContext muleContext = this.createAppMuleContext(applicationConfig.applicationResources);
            this.muleContexts.put(applicationConfig.applicationName, muleContext);
        }
    }

    @After
    public void disposeMuleContexts() {
        for (MuleContext muleContext : this.muleContexts.values()) {
            try {
                this.disposeMuleContext(muleContext);
            }
            catch (Exception exception) {}
        }
        this.muleContexts.clear();
    }

    protected MuleContext createAppMuleContext(String[] configResource) throws Exception {
        return new ApplicationContextBuilder().setDomainContext(this.domainContext).setApplicationResources(configResource).build();
    }

    public abstract ApplicationConfig[] getConfigResources();

    public MuleContext getMuleContextForApp(String applicationName) {
        return this.muleContexts.get(applicationName);
    }

    public class ApplicationConfig {
        String applicationName;
        String[] applicationResources;

        public ApplicationConfig(String applicationName, String[] applicationResources) {
            this.applicationName = applicationName;
            this.applicationResources = applicationResources;
        }
    }
}

