/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.functional;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicInteger;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleEventContext;
import org.mule.api.lifecycle.Callable;
import org.mule.tck.functional.EventCallback;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.util.ClassUtils;
import org.mule.util.StringMessageUtils;

public class FunctionalStreamingTestComponent
implements Callable {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private static AtomicInteger count = new AtomicInteger(0);
    private int number = count.incrementAndGet();
    public static final int STREAM_SAMPLE_SIZE = 4;
    public static final int STREAM_BUFFER_SIZE = 4096;
    private EventCallback eventCallback;
    private String summary = null;
    private long targetSize = -1L;

    public FunctionalStreamingTestComponent() {
        this.logger.debug((Object)("creating " + this.toString()));
    }

    public void setEventCallback(EventCallback eventCallback, long targetSize) {
        this.logger.debug((Object)("setting callback: " + eventCallback + " in " + this.toString()));
        this.eventCallback = eventCallback;
        this.targetSize = targetSize;
    }

    public String getSummary() {
        return this.summary;
    }

    public int getNumber() {
        return this.number;
    }

    public Object onCall(MuleEventContext context) throws Exception {
        InputStream in = (InputStream)context.getMessage().getPayload(DataTypeFactory.create(InputStream.class));
        try {
            this.logger.debug((Object)("arrived at " + this.toString()));
            byte[] startData = new byte[4];
            long startDataSize = 0L;
            byte[] endData = new byte[4];
            long endDataSize = 0L;
            long endRingPointer = 0L;
            long streamLength = 0L;
            byte[] buffer = new byte[4096];
            long bytesRead = 0L;
            while (bytesRead >= 0L) {
                long i;
                bytesRead = this.read(in, buffer);
                if (bytesRead <= 0L) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("read " + bytesRead + " bytes"));
                }
                streamLength += bytesRead;
                long startOfEndBytes = 0L;
                for (i = 0L; startDataSize < 4L && i < bytesRead; ++i) {
                    startData[(int)startDataSize++] = buffer[(int)i];
                    ++startOfEndBytes;
                }
                for (i = startOfEndBytes = Math.max(startOfEndBytes, bytesRead - 4L); i < bytesRead; ++i) {
                    ++endDataSize;
                    endData[(int)(endRingPointer++ % 4L)] = buffer[(int)i];
                }
                if (streamLength < this.targetSize) continue;
                this.doCallback(startData, startDataSize, endData, endDataSize, endRingPointer, streamLength, context);
            }
            in.close();
        }
        catch (Exception e) {
            in.close();
            e.printStackTrace();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)e);
            }
            throw e;
        }
        return null;
    }

    protected int read(InputStream in, byte[] buffer) throws IOException {
        return in.read(buffer);
    }

    private void doCallback(byte[] startData, long startDataSize, byte[] endData, long endDataSize, long endRingPointer, long streamLength, MuleEventContext context) throws Exception {
        StringBuffer result = new StringBuffer("Received stream");
        result.append("; length: ");
        result.append(streamLength);
        result.append("; '");
        for (long i = 0L; i < startDataSize; ++i) {
            result.append((char)startData[(int)i]);
        }
        long endSize = Math.min(endDataSize, 4L);
        if (endSize > 0L) {
            result.append("...");
            for (long i = 0L; i < endSize; ++i) {
                result.append((char)endData[(int)((endRingPointer + i) % 4L)]);
            }
        }
        result.append("'");
        this.summary = result.toString();
        String msg = StringMessageUtils.getBoilerPlate((String)("Message Received in service: " + context.getFlowConstruct().getName() + ". " + this.summary + "\n callback: " + this.eventCallback), (char)'*', (int)80);
        this.logger.info((Object)msg);
        if (this.eventCallback != null) {
            this.eventCallback.eventReceived(context, this);
        }
    }

    public String toString() {
        return ClassUtils.getSimpleName(this.getClass()) + "/" + this.number;
    }
}

