/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck;

import java.util.List;
import org.mule.DefaultExceptionStrategy;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleException;
import org.mule.api.component.JavaComponent;
import org.mule.api.config.ThreadingProfile;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.routing.InboundRouter;
import org.mule.api.routing.InboundRouterCollection;
import org.mule.api.routing.InterfaceBinding;
import org.mule.api.routing.OutboundRouter;
import org.mule.api.routing.OutboundRouterCollection;
import org.mule.api.routing.filter.Filter;
import org.mule.api.service.Service;
import org.mule.api.transformer.Transformer;
import org.mule.component.AbstractComponent;
import org.mule.component.PooledJavaComponent;
import org.mule.config.PoolingProfile;
import org.mule.config.QueueProfile;
import org.mule.interceptor.InterceptorStack;
import org.mule.interceptor.LoggingInterceptor;
import org.mule.interceptor.TimerInterceptor;
import org.mule.model.seda.SedaService;
import org.mule.routing.filters.MessagePropertyFilter;
import org.mule.routing.filters.PayloadTypeFilter;
import org.mule.routing.filters.RegExFilter;
import org.mule.routing.filters.logic.AndFilter;
import org.mule.routing.inbound.IdempotentReceiver;
import org.mule.routing.inbound.SelectiveConsumer;
import org.mule.routing.outbound.FilteringOutboundRouter;
import org.mule.tck.AbstractScriptConfigBuilderTestCase;
import org.mule.tck.testmodels.mule.TestCatchAllStrategy;
import org.mule.tck.testmodels.mule.TestCompressionTransformer;
import org.mule.tck.testmodels.mule.TestConnector;
import org.mule.tck.testmodels.mule.TestExceptionStrategy;
import org.mule.tck.testmodels.mule.TestTransactionFactory;
import org.mule.transformer.TransformerUtils;
import org.mule.transport.AbstractConnector;

public abstract class AbstractConfigBuilderTestCase
extends AbstractScriptConfigBuilderTestCase {
    public AbstractConfigBuilderTestCase(boolean legacy) {
        super(legacy);
    }

    public void testManagerConfig() throws Exception {
        super.testManagerConfig();
        AbstractConfigBuilderTestCase.assertNotNull((Object)muleContext.getTransactionManager());
    }

    public void testConnectorConfig() throws Exception {
        super.testConnectorConfig();
        TestConnector c = (TestConnector)muleContext.getRegistry().lookupConnector("dummyConnector");
        AbstractConfigBuilderTestCase.assertNotNull((Object)c);
        AbstractConfigBuilderTestCase.assertNotNull((Object)c.getExceptionListener());
        AbstractConfigBuilderTestCase.assertTrue((boolean)(c.getExceptionListener() instanceof TestExceptionStrategy));
    }

    public void testGlobalEndpointConfig() throws MuleException {
        super.testGlobalEndpointConfig();
        InboundEndpoint endpoint = muleContext.getRegistry().lookupEndpointFactory().getInboundEndpoint("fruitBowlEndpoint");
        AbstractConfigBuilderTestCase.assertNotNull((Object)endpoint);
        AbstractConfigBuilderTestCase.assertEquals((String)endpoint.getEndpointURI().getAddress(), (String)"fruitBowlPublishQ");
        MessagePropertyFilter filter = (MessagePropertyFilter)endpoint.getFilter();
        AbstractConfigBuilderTestCase.assertNotNull((Object)filter);
        AbstractConfigBuilderTestCase.assertEquals((String)"foo=bar", (String)filter.getPattern());
    }

    public void testEndpointConfig() throws MuleException {
        super.testEndpointConfig();
        InboundEndpoint endpoint = muleContext.getRegistry().lookupEndpointFactory().getInboundEndpoint("waterMelonEndpoint");
        AbstractConfigBuilderTestCase.assertNotNull((Object)endpoint);
        AbstractConfigBuilderTestCase.assertEquals((String)"UTF-8-TEST", (String)endpoint.getEncoding());
        AbstractConfigBuilderTestCase.assertEquals((String)"test.queue", (String)endpoint.getEndpointURI().getAddress());
        Service service = muleContext.getRegistry().lookupService("appleComponent2");
        AbstractConfigBuilderTestCase.assertNotNull((Object)service);
    }

    public void testExceptionStrategy2() {
        Service service = muleContext.getRegistry().lookupService("appleComponent");
        AbstractConfigBuilderTestCase.assertNotNull((Object)service.getExceptionListener());
        AbstractConfigBuilderTestCase.assertTrue((boolean)DefaultExceptionStrategy.class.isAssignableFrom(service.getExceptionListener().getClass()));
    }

    public void testTransformerConfig() {
        super.testTransformerConfig();
        Transformer t = muleContext.getRegistry().lookupTransformer("TestCompressionTransformer");
        AbstractConfigBuilderTestCase.assertNotNull((Object)t);
        AbstractConfigBuilderTestCase.assertTrue((boolean)(t instanceof TestCompressionTransformer));
        AbstractConfigBuilderTestCase.assertEquals((Object)t.getReturnClass(), String.class);
        AbstractConfigBuilderTestCase.assertNotNull((Object)((TestCompressionTransformer)t).getContainerProperty());
    }

    public void testModelConfig() throws Exception {
        super.testModelConfig();
        AbstractConfigBuilderTestCase.assertNotNull((Object)muleContext.getRegistry().lookupService("appleComponent"));
        AbstractConfigBuilderTestCase.assertNotNull((Object)muleContext.getRegistry().lookupService("appleComponent2"));
    }

    public void testOutboundRouterConfig2() {
        Service service = muleContext.getRegistry().lookupService("appleComponent");
        AbstractConfigBuilderTestCase.assertNotNull((Object)service.getOutboundRouter());
        OutboundRouterCollection router = service.getOutboundRouter();
        AbstractConfigBuilderTestCase.assertNotNull((Object)router.getCatchAllStrategy());
        AbstractConfigBuilderTestCase.assertEquals((int)2, (int)router.getRouters().size());
        OutboundRouter route1 = (OutboundRouter)router.getRouters().get(0);
        AbstractConfigBuilderTestCase.assertTrue((boolean)(route1 instanceof FilteringOutboundRouter));
        AbstractConfigBuilderTestCase.assertNotNull((Object)((FilteringOutboundRouter)route1).getTransformers());
        AbstractConfigBuilderTestCase.assertTrue((boolean)(TransformerUtils.firstOrNull((List)((FilteringOutboundRouter)route1).getTransformers()) instanceof TestCompressionTransformer));
        Filter filter = ((FilteringOutboundRouter)route1).getFilter();
        AbstractConfigBuilderTestCase.assertNotNull((Object)filter);
        AbstractConfigBuilderTestCase.assertTrue((boolean)(filter instanceof PayloadTypeFilter));
        AbstractConfigBuilderTestCase.assertEquals(String.class, (Object)((PayloadTypeFilter)filter).getExpectedType());
        OutboundRouter route2 = (OutboundRouter)router.getRouters().get(1);
        AbstractConfigBuilderTestCase.assertTrue((boolean)(route2 instanceof FilteringOutboundRouter));
        Filter filter2 = ((FilteringOutboundRouter)route2).getFilter();
        AbstractConfigBuilderTestCase.assertNotNull((Object)filter2);
        AbstractConfigBuilderTestCase.assertTrue((boolean)(filter2 instanceof AndFilter));
        AbstractConfigBuilderTestCase.assertEquals((int)2, (int)((AndFilter)filter2).getFilters().size());
        Filter left = (Filter)((AndFilter)filter2).getFilters().get(0);
        Filter right = (Filter)((AndFilter)filter2).getFilters().get(1);
        AbstractConfigBuilderTestCase.assertNotNull((Object)left);
        AbstractConfigBuilderTestCase.assertTrue((boolean)(left instanceof RegExFilter));
        AbstractConfigBuilderTestCase.assertEquals((String)"the quick brown (.*)", (String)((RegExFilter)left).getPattern());
        AbstractConfigBuilderTestCase.assertNotNull((Object)right);
        AbstractConfigBuilderTestCase.assertTrue((boolean)(right instanceof RegExFilter));
        AbstractConfigBuilderTestCase.assertEquals((String)"(.*) brown (.*)", (String)((RegExFilter)right).getPattern());
        AbstractConfigBuilderTestCase.assertTrue((boolean)(router.getCatchAllStrategy() instanceof TestCatchAllStrategy));
    }

    public void testInboundRouterConfig2() {
        Service service = muleContext.getRegistry().lookupService("appleComponent");
        AbstractConfigBuilderTestCase.assertNotNull((Object)service.getInboundRouter());
        InboundRouterCollection messageRouter = service.getInboundRouter();
        AbstractConfigBuilderTestCase.assertNotNull((Object)messageRouter.getCatchAllStrategy());
        AbstractConfigBuilderTestCase.assertEquals((int)2, (int)messageRouter.getRouters().size());
        InboundRouter router = (InboundRouter)messageRouter.getRouters().get(0);
        AbstractConfigBuilderTestCase.assertTrue((boolean)(router instanceof SelectiveConsumer));
        SelectiveConsumer sc = (SelectiveConsumer)router;
        AbstractConfigBuilderTestCase.assertNotNull((Object)sc.getFilter());
        Filter filter = sc.getFilter();
        AbstractConfigBuilderTestCase.assertTrue((boolean)(filter instanceof PayloadTypeFilter));
        AbstractConfigBuilderTestCase.assertEquals(String.class, (Object)((PayloadTypeFilter)filter).getExpectedType());
        InboundRouter router2 = (InboundRouter)messageRouter.getRouters().get(1);
        AbstractConfigBuilderTestCase.assertTrue((boolean)(router2 instanceof IdempotentReceiver));
    }

    public void testThreadingConfig() throws DefaultMuleException {
        int defaultMaxBufferSize = 42;
        int defaultMaxThreadsActive = 16;
        int defaultMaxThreadsIdle = 3;
        int defaultThreadPoolExhaustedAction = 0;
        int defaultThreadTTL = 60001;
        int connectorMaxBufferSize = 2;
        int componentMaxBufferSize = 6;
        int componentMaxThreadsActive = 12;
        int componentMaxThreadsIdle = 6;
        int componentThreadPoolExhaustedAction = 1;
        ThreadingProfile tp = muleContext.getDefaultThreadingProfile();
        AbstractConfigBuilderTestCase.assertEquals((int)defaultMaxBufferSize, (int)tp.getMaxBufferSize());
        AbstractConfigBuilderTestCase.assertEquals((int)defaultMaxThreadsActive, (int)tp.getMaxThreadsActive());
        AbstractConfigBuilderTestCase.assertEquals((int)defaultMaxThreadsIdle, (int)tp.getMaxThreadsIdle());
        AbstractConfigBuilderTestCase.assertEquals((int)defaultThreadPoolExhaustedAction, (int)tp.getPoolExhaustedAction());
        AbstractConfigBuilderTestCase.assertEquals((long)defaultThreadTTL, (long)tp.getThreadTTL());
        tp = muleContext.getDefaultServiceThreadingProfile();
        AbstractConfigBuilderTestCase.assertEquals((int)defaultMaxBufferSize, (int)tp.getMaxBufferSize());
        AbstractConfigBuilderTestCase.assertEquals((int)defaultMaxThreadsActive, (int)tp.getMaxThreadsActive());
        AbstractConfigBuilderTestCase.assertEquals((int)defaultMaxThreadsIdle, (int)tp.getMaxThreadsIdle());
        AbstractConfigBuilderTestCase.assertEquals((int)defaultThreadPoolExhaustedAction, (int)tp.getPoolExhaustedAction());
        AbstractConfigBuilderTestCase.assertEquals((long)defaultThreadTTL, (long)tp.getThreadTTL());
        AbstractConnector c = (AbstractConnector)muleContext.getRegistry().lookupConnector("dummyConnector");
        tp = c.getDispatcherThreadingProfile();
        AbstractConfigBuilderTestCase.assertEquals((int)connectorMaxBufferSize, (int)tp.getMaxBufferSize());
        AbstractConfigBuilderTestCase.assertEquals((int)defaultMaxThreadsActive, (int)tp.getMaxThreadsActive());
        AbstractConfigBuilderTestCase.assertEquals((int)defaultMaxThreadsIdle, (int)tp.getMaxThreadsIdle());
        AbstractConfigBuilderTestCase.assertEquals((int)defaultThreadPoolExhaustedAction, (int)tp.getPoolExhaustedAction());
        AbstractConfigBuilderTestCase.assertEquals((long)defaultThreadTTL, (long)tp.getThreadTTL());
        Service service = muleContext.getRegistry().lookupService("appleComponent2");
        AbstractConfigBuilderTestCase.assertTrue((String)"service must be SedaService to get threading profile", (boolean)(service instanceof SedaService));
        tp = ((SedaService)service).getThreadingProfile();
        AbstractConfigBuilderTestCase.assertEquals((int)componentMaxBufferSize, (int)tp.getMaxBufferSize());
        AbstractConfigBuilderTestCase.assertEquals((int)componentMaxThreadsActive, (int)tp.getMaxThreadsActive());
        AbstractConfigBuilderTestCase.assertEquals((int)componentMaxThreadsIdle, (int)tp.getMaxThreadsIdle());
        AbstractConfigBuilderTestCase.assertEquals((int)componentThreadPoolExhaustedAction, (int)tp.getPoolExhaustedAction());
        AbstractConfigBuilderTestCase.assertEquals((long)defaultThreadTTL, (long)tp.getThreadTTL());
    }

    public void testPoolingConfig() {
        Service service = muleContext.getRegistry().lookupService("appleComponent2");
        PoolingProfile pp = ((PooledJavaComponent)service.getComponent()).getPoolingProfile();
        AbstractConfigBuilderTestCase.assertEquals((int)9, (int)pp.getMaxActive());
        AbstractConfigBuilderTestCase.assertEquals((int)6, (int)pp.getMaxIdle());
        AbstractConfigBuilderTestCase.assertEquals((long)4002L, (long)pp.getMaxWait());
        AbstractConfigBuilderTestCase.assertEquals((int)0, (int)pp.getExhaustedAction());
        AbstractConfigBuilderTestCase.assertEquals((int)2, (int)pp.getInitialisationPolicy());
    }

    public void testQueueProfileConfig() {
        Service service = muleContext.getRegistry().lookupService("appleComponent2");
        QueueProfile qp = ((SedaService)service).getQueueProfile();
        AbstractConfigBuilderTestCase.assertEquals((int)102, (int)qp.getMaxOutstandingMessages());
        AbstractConfigBuilderTestCase.assertTrue((boolean)qp.isPersistent());
    }

    public void testEndpointProperties() throws Exception {
        Service service = muleContext.getRegistry().lookupService("appleComponent2");
        InboundEndpoint inEndpoint = service.getInboundRouter().getEndpoint("transactedInboundEndpoint");
        AbstractConfigBuilderTestCase.assertNotNull((Object)inEndpoint);
        AbstractConfigBuilderTestCase.assertNotNull((Object)inEndpoint.getProperties());
        AbstractConfigBuilderTestCase.assertEquals((Object)"Prop1", inEndpoint.getProperties().get("testEndpointProperty"));
    }

    public void testTransactionConfig() throws Exception {
        Service apple = muleContext.getRegistry().lookupService("appleComponent2");
        InboundEndpoint inEndpoint = apple.getInboundRouter().getEndpoint("transactedInboundEndpoint");
        AbstractConfigBuilderTestCase.assertNotNull((Object)inEndpoint);
        AbstractConfigBuilderTestCase.assertEquals((int)1, (int)apple.getOutboundRouter().getRouters().size());
        AbstractConfigBuilderTestCase.assertNotNull((Object)inEndpoint.getTransactionConfig());
        AbstractConfigBuilderTestCase.assertEquals((byte)1, (byte)inEndpoint.getTransactionConfig().getAction());
        AbstractConfigBuilderTestCase.assertTrue((boolean)(inEndpoint.getTransactionConfig().getFactory() instanceof TestTransactionFactory));
        AbstractConfigBuilderTestCase.assertNull((Object)inEndpoint.getTransactionConfig().getConstraint());
        OutboundRouter outRouter = (OutboundRouter)apple.getOutboundRouter().getRouters().get(0);
        OutboundEndpoint outEndpoint = (OutboundEndpoint)outRouter.getEndpoints().get(0);
        AbstractConfigBuilderTestCase.assertNotNull((Object)outEndpoint);
    }

    public void testEnvironmentProperties() {
        AbstractConfigBuilderTestCase.assertEquals((Object)"true", (Object)muleContext.getRegistry().lookupObject("doCompression"));
        AbstractConfigBuilderTestCase.assertEquals((Object)"this was set from the manager properties!", (Object)muleContext.getRegistry().lookupObject("beanProperty1"));
        AbstractConfigBuilderTestCase.assertNotNull((Object)muleContext.getRegistry().lookupObject("OS_Version"));
    }

    public void testBindngProxyCreation() {
        Service orange = muleContext.getRegistry().lookupService("orangeComponent");
        AbstractConfigBuilderTestCase.assertNotNull((Object)orange);
        AbstractConfigBuilderTestCase.assertTrue((boolean)(orange.getComponent() instanceof JavaComponent));
        InterfaceBinding r = (InterfaceBinding)((JavaComponent)orange.getComponent()).getBindingCollection().getRouters().get(0);
        AbstractConfigBuilderTestCase.assertNotNull((Object)r);
    }

    public void testMuleConfiguration() {
        AbstractConfigBuilderTestCase.assertTrue((boolean)muleContext.getConfiguration().isDefaultSynchronousEndpoints());
    }

    public void testGlobalInterceptorStack() {
        InterceptorStack interceptorStack = (InterceptorStack)muleContext.getRegistry().lookupObject("testInterceptorStack");
        AbstractConfigBuilderTestCase.assertNotNull((Object)interceptorStack);
        AbstractConfigBuilderTestCase.assertEquals((int)3, (int)interceptorStack.getInterceptors().size());
        AbstractConfigBuilderTestCase.assertEquals(LoggingInterceptor.class, interceptorStack.getInterceptors().get(0).getClass());
        AbstractConfigBuilderTestCase.assertEquals(TimerInterceptor.class, interceptorStack.getInterceptors().get(1).getClass());
        AbstractConfigBuilderTestCase.assertEquals(LoggingInterceptor.class, interceptorStack.getInterceptors().get(2).getClass());
    }

    public void testInterceptors() {
        Service service = muleContext.getRegistry().lookupService("orangeComponent");
        InterceptorStack globalInterceptorStack = (InterceptorStack)muleContext.getRegistry().lookupObject("testInterceptorStack");
        AbstractComponent component = (AbstractComponent)service.getComponent();
        AbstractConfigBuilderTestCase.assertEquals((int)3, (int)component.getInterceptors().size());
        AbstractConfigBuilderTestCase.assertEquals(LoggingInterceptor.class, component.getInterceptors().get(0).getClass());
        AbstractConfigBuilderTestCase.assertEquals((Object)globalInterceptorStack, component.getInterceptors().get(1));
        AbstractConfigBuilderTestCase.assertEquals(TimerInterceptor.class, component.getInterceptors().get(2).getClass());
    }
}

