/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.functional;

import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleServer;
import org.mule.RequestContext;
import org.mule.api.MuleContext;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.context.MuleContextAware;
import org.mule.api.context.notification.ServerNotification;
import org.mule.api.lifecycle.Callable;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.tck.exceptions.FunctionalTestException;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.functional.FunctionalTestNotification;
import org.mule.tck.functional.Receiveable;
import org.mule.util.NumberUtils;
import org.mule.util.StringMessageUtils;
import org.mule.util.SystemUtils;

public class FunctionalTestComponent
implements Callable,
Initialisable,
Disposable,
MuleContextAware,
Receiveable {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    public static final int STREAM_SAMPLE_SIZE = 4;
    public static final int STREAM_BUFFER_SIZE = 4096;
    private EventCallback eventCallback;
    private Object returnData = null;
    private boolean throwException = false;
    private boolean enableMessageHistory = true;
    private boolean enableNotifications = true;
    private boolean doInboundTransform = true;
    private String appendString;
    private Class exceptionToThrow;
    private long waitTime = 0L;
    private boolean logMessageDetails = false;
    private MuleContext muleContext;
    private List messageHistory;

    public void initialise() {
        if (this.enableMessageHistory) {
            this.messageHistory = new CopyOnWriteArrayList();
        }
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public void dispose() {
    }

    public Object onCall(MuleEventContext context) throws Exception {
        if (this.isThrowException()) {
            this.throwException();
        }
        return this.process(this.getMessageFromContext(context), context);
    }

    private Object getMessageFromContext(MuleEventContext context) throws MuleException {
        if (this.isDoInboundTransform()) {
            Object o = context.transformMessage();
            if (this.getAppendString() != null && !(o instanceof String)) {
                o = context.transformMessageToString();
            }
            return o;
        }
        if (this.getAppendString() != null) {
            return context.getMessageAsString();
        }
        return context.getMessage().getPayload();
    }

    public Object onReceive(Object data) throws Exception {
        MuleEventContext context = RequestContext.getEventContext();
        if (this.isThrowException()) {
            this.throwException();
        }
        return this.process(data, context);
    }

    protected void throwException() throws Exception {
        if (this.getExceptionToThrow() != null) {
            throw (Exception)this.getExceptionToThrow().newInstance();
        }
        throw new FunctionalTestException();
    }

    protected String append(String contents, MuleMessage message) {
        return contents + this.muleContext.getExpressionManager().parse(this.appendString, message);
    }

    protected Object process(Object data, MuleEventContext context) throws Exception {
        if (this.enableMessageHistory) {
            this.messageHistory.add(data);
        }
        if (this.logger.isInfoEnabled()) {
            String msg = StringMessageUtils.getBoilerPlate((String)("Message Received in service: " + context.getService().getName() + ". Content is: " + StringMessageUtils.truncate((String)data.toString(), (int)100, (boolean)true)), (char)'*', (int)80);
            this.logger.info((Object)msg);
        }
        MuleMessage message = context.getMessage();
        if (this.isLogMessageDetails() && this.logger.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Full Message payload: ").append(SystemUtils.LINE_SEPARATOR);
            sb.append(message.getPayload()).append(SystemUtils.LINE_SEPARATOR);
            sb.append(StringMessageUtils.headersToString((MuleMessage)message));
            this.logger.info((Object)sb.toString());
        }
        if (this.eventCallback != null) {
            this.eventCallback.eventReceived(context, this);
        }
        Object replyMessage = this.returnData != null ? (this.returnData instanceof String && this.muleContext.getExpressionManager().isValidExpression(this.returnData.toString()) ? this.muleContext.getExpressionManager().parse(this.returnData.toString(), message) : this.returnData) : (this.appendString != null ? this.append(data.toString(), message) : data);
        if (this.isEnableNotifications()) {
            MuleContext muleContext = context.getMuleContext();
            if (muleContext == null) {
                this.logger.warn((Object)"No MuleContext available from MuleEventContext");
                muleContext = MuleServer.getMuleContext();
            }
            muleContext.fireNotification((ServerNotification)new FunctionalTestNotification(context, replyMessage, -999999));
        }
        if (this.waitTime > 0L) {
            try {
                Thread.sleep(this.waitTime);
            }
            catch (InterruptedException e) {
                this.logger.info((Object)"FunctionalTestComponent waitTime was interrupted");
            }
        }
        return replyMessage;
    }

    public EventCallback getEventCallback() {
        return this.eventCallback;
    }

    public void setEventCallback(EventCallback eventCallback) {
        this.eventCallback = eventCallback;
    }

    public Object getReturnData() {
        return this.returnData;
    }

    public void setReturnData(Object returnData) {
        this.returnData = returnData;
    }

    public boolean isThrowException() {
        return this.throwException;
    }

    public void setThrowException(boolean throwException) {
        this.throwException = throwException;
    }

    public boolean isEnableMessageHistory() {
        return this.enableMessageHistory;
    }

    public void setEnableMessageHistory(boolean enableMessageHistory) {
        this.enableMessageHistory = enableMessageHistory;
    }

    public int getReceivedMessagesCount() {
        if (this.messageHistory != null) {
            return this.messageHistory.size();
        }
        return NumberUtils.INTEGER_MINUS_ONE;
    }

    public Object getReceivedMessage(int number) {
        Object message = null;
        if (this.messageHistory != null && number <= this.messageHistory.size()) {
            message = this.messageHistory.get(number - 1);
        }
        return message;
    }

    public Object getLastReceivedMessage() {
        if (this.messageHistory != null) {
            return this.messageHistory.get(this.messageHistory.size() - 1);
        }
        return null;
    }

    public String getAppendString() {
        return this.appendString;
    }

    public void setAppendString(String appendString) {
        this.appendString = appendString;
    }

    public boolean isEnableNotifications() {
        return this.enableNotifications;
    }

    public void setEnableNotifications(boolean enableNotifications) {
        this.enableNotifications = enableNotifications;
    }

    public Class getExceptionToThrow() {
        return this.exceptionToThrow;
    }

    public void setExceptionToThrow(Class exceptionToThrow) {
        this.exceptionToThrow = exceptionToThrow;
    }

    public long getWaitTime() {
        return this.waitTime;
    }

    public void setWaitTime(long waitTime) {
        this.waitTime = waitTime;
    }

    public boolean isDoInboundTransform() {
        return this.doInboundTransform;
    }

    public void setDoInboundTransform(boolean doInboundTransform) {
        this.doInboundTransform = doInboundTransform;
    }

    public boolean isLogMessageDetails() {
        return this.logMessageDetails;
    }

    public void setLogMessageDetails(boolean logMessageDetails) {
        this.logMessageDetails = logMessageDetails;
    }
}

