/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.config;

import java.io.IOException;
import java.util.HashMap;
import org.mule.component.DefaultJavaComponent;
import org.mule.config.spring.parsers.specific.ComponentDefinitionParser;
import org.mule.object.SingletonObjectFactory;
import org.mule.tck.functional.FunctionalTestComponent2;
import org.mule.util.IOUtils;
import org.mule.util.StringUtils;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TestComponentDefinitionParser
extends ComponentDefinitionParser {
    private static Class OBJECT_FACTORY_TYPE = SingletonObjectFactory.class;
    private Class componentInstanceClass = FunctionalTestComponent2.class;

    public TestComponentDefinitionParser() {
        super(DefaultJavaComponent.class);
        this.addIgnored("appendString");
        this.addIgnored("enableMessageHistory");
        this.addIgnored("enableNotifications");
        this.addIgnored("throwException");
        this.addIgnored("exceptionToThrow");
        this.addIgnored("waitTime");
    }

    protected void parseChild(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        Element parent = (Element)element.getParentNode();
        String serviceName = parent.getAttribute("name");
        builder.addPropertyReference("service", serviceName);
        GenericBeanDefinition objectFactoryBeanDefinition = new GenericBeanDefinition();
        objectFactoryBeanDefinition.setBeanClass(OBJECT_FACTORY_TYPE);
        objectFactoryBeanDefinition.getPropertyValues().addPropertyValue("objectClass", (Object)this.componentInstanceClass);
        objectFactoryBeanDefinition.setInitMethodName("initialise");
        objectFactoryBeanDefinition.setDestroyMethodName("dispose");
        HashMap<String, String> props = new HashMap<String, String>();
        for (int i = 0; i < element.getAttributes().getLength(); ++i) {
            Node n = element.getAttributes().item(i);
            props.put(n.getLocalName(), n.getNodeValue());
        }
        String returnData = null;
        NodeList list = element.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            if (!"return-data".equals(list.item(i).getLocalName())) continue;
            Element rData = (Element)list.item(i);
            if (StringUtils.isNotEmpty((String)rData.getAttribute("file"))) {
                String file = rData.getAttribute("file");
                try {
                    returnData = IOUtils.getResourceAsString((String)file, ((Object)((Object)this)).getClass());
                    break;
                }
                catch (IOException e) {
                    throw new BeanCreationException("Failed to load test-data resource: " + file, (Throwable)e);
                }
            }
            returnData = rData.getTextContent();
            break;
        }
        if (returnData != null) {
            props.put("returnData", returnData);
        }
        objectFactoryBeanDefinition.getPropertyValues().addPropertyValue("properties", props);
        builder.addPropertyValue("objectFactory", (Object)objectFactoryBeanDefinition);
        super.parseChild(element, parserContext, builder);
    }
}

