/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.functional;

import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleException;
import org.mule.config.i18n.MessageFactory;
import org.mule.impl.RequestContext;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.functional.FunctionalTestNotification;
import org.mule.umo.UMOEventContext;
import org.mule.umo.lifecycle.Callable;
import org.mule.umo.lifecycle.Disposable;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.umo.manager.UMOServerNotification;
import org.mule.util.NumberUtils;
import org.mule.util.StringMessageUtils;

public class FunctionalTestComponent
implements Callable,
Initialisable,
Disposable {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    public static final int STREAM_SAMPLE_SIZE = 4;
    public static final int STREAM_BUFFER_SIZE = 4096;
    private EventCallback eventCallback;
    private Object returnMessage = null;
    private boolean appendComponentName = false;
    private boolean throwException = false;
    private boolean enableMessageHistory = true;
    private List messageHistory;

    public void initialise() {
        if (this.enableMessageHistory) {
            this.messageHistory = new CopyOnWriteArrayList();
        }
    }

    public void dispose() {
    }

    public Object onCall(UMOEventContext context) throws Exception {
        if (this.enableMessageHistory) {
            this.messageHistory.add(context.getTransformedMessage());
        }
        String contents = context.getTransformedMessageAsString();
        String msg = StringMessageUtils.getBoilerPlate((String)("Message Received in component: " + context.getComponentDescriptor().getName() + ". Content is: " + StringMessageUtils.truncate((String)contents, (int)100, (boolean)true)), (char)'*', (int)80);
        this.logger.info((Object)msg);
        Object replyMessage = this.returnMessage != null ? this.returnMessage : FunctionalTestComponent.received(contents) + (this.appendComponentName ? " " + context.getComponentDescriptor().getName() : "");
        context.getManagementContext().fireNotification((UMOServerNotification)new FunctionalTestNotification(context, replyMessage, -999999));
        if (this.throwException) {
            throw new MuleException(MessageFactory.createStaticMessage((String)"Functional Test Component Exception"));
        }
        if (this.eventCallback != null) {
            this.eventCallback.eventReceived(context, this);
        }
        return replyMessage;
    }

    public static String received(String contents) {
        return contents + " Received";
    }

    public Object onReceive(Object data) throws Exception {
        UMOEventContext context = RequestContext.getEventContext();
        String contents = data.toString();
        String msg = StringMessageUtils.getBoilerPlate((String)("Message Received in component: " + context.getComponentDescriptor().getName() + ". Content is: " + StringMessageUtils.truncate((String)contents, (int)100, (boolean)true)), (char)'*', (int)80);
        this.logger.info((Object)msg);
        if (this.eventCallback != null) {
            this.eventCallback.eventReceived(context, this);
        }
        Object replyMessage = this.returnMessage != null ? this.returnMessage : contents + " Received";
        context.getManagementContext().fireNotification((UMOServerNotification)new FunctionalTestNotification(context, replyMessage, -999999));
        if (this.throwException) {
            if (this.returnMessage != null && this.returnMessage instanceof Exception) {
                throw (Exception)this.returnMessage;
            }
            throw new MuleException(MessageFactory.createStaticMessage((String)"Functional Test Component Exception"));
        }
        return replyMessage;
    }

    public EventCallback getEventCallback() {
        return this.eventCallback;
    }

    public void setEventCallback(EventCallback eventCallback) {
        this.eventCallback = eventCallback;
    }

    public Object getReturnMessage() {
        return this.returnMessage;
    }

    public void setReturnMessage(Object returnMessage) {
        this.returnMessage = returnMessage;
    }

    public boolean isThrowException() {
        return this.throwException;
    }

    public void setThrowException(boolean throwException) {
        this.throwException = throwException;
    }

    public boolean isAppendComponentName() {
        return this.appendComponentName;
    }

    public void setAppendComponentName(boolean appendComponentName) {
        this.appendComponentName = appendComponentName;
    }

    public boolean isEnableMessageHistory() {
        return this.enableMessageHistory;
    }

    public void setEnableMessageHistory(boolean enableMessageHistory) {
        this.enableMessageHistory = enableMessageHistory;
    }

    public int getReceivedMessages() {
        if (this.messageHistory != null) {
            return this.messageHistory.size();
        }
        return NumberUtils.INTEGER_MINUS_ONE;
    }

    public Object getReceivedMessage(int number) {
        Object message = null;
        if (this.messageHistory != null && number <= this.messageHistory.size()) {
            message = this.messageHistory.get(number - 1);
        }
        return message;
    }

    public Object getLastReceivedMessage() {
        if (this.messageHistory != null) {
            return this.messageHistory.get(this.messageHistory.size() - 1);
        }
        return null;
    }
}

