/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.petstore.extension;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.extension.api.annotation.execution.OnError;
import org.mule.runtime.extension.api.annotation.execution.OnSuccess;
import org.mule.runtime.extension.api.annotation.execution.OnTerminate;
import org.mule.runtime.extension.api.annotation.metadata.MetadataScope;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.source.PollContext;
import org.mule.runtime.extension.api.runtime.source.PollingSource;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;
import org.mule.sdk.api.annotation.param.Parameter;
import org.mule.test.petstore.extension.PollingSourceMetadataResolver;

@MetadataScope(outputResolver=PollingSourceMetadataResolver.class)
@MediaType(value="text/plain")
public class PartialPetAdoptionSource
extends PollingSource<String, Void> {
    public static final List<String> ALL_PETS = Arrays.asList("Grumpy Cat", "Colonel Meow", "Silvester", "Lil bub", "Macri", "Pappo");
    public static int ADOPTED_PET_COUNT;
    public static int FAILED_ADOPTION_COUNT;
    public static int COMPLETED_POLLS;
    public static int REJECTED_ADOPTIONS;
    private static int timesPolled;
    private static int POLLS_TO_ADD_PET;
    private List<String> pets;
    @Parameter
    @Optional(defaultValue="false")
    private boolean watermark;
    @org.mule.runtime.extension.api.annotation.param.Parameter
    @Optional(defaultValue="false")
    private boolean idempotent;

    protected void doStart() throws MuleException {
        this.pets = new ArrayList<String>(ALL_PETS);
        this.resetCounters();
    }

    protected void doStop() {
        this.pets.clear();
        this.resetCounters();
    }

    @OnSuccess
    public void onSuccess() {
        ++ADOPTED_PET_COUNT;
    }

    @OnError
    public void onError() {
        ++FAILED_ADOPTION_COUNT;
    }

    @OnTerminate
    public void onTerminate() {
        ++COMPLETED_POLLS;
    }

    public void poll(PollContext<String, Void> pollContext) {
        pollContext.setWatermarkComparator(Comparator.naturalOrder());
        int petsToAdopt = Math.min(timesPolled / POLLS_TO_ADD_PET + 1, this.pets.size());
        this.pets.subList(0, petsToAdopt).stream().map(p -> Result.builder().output(p).build()).forEach(result -> pollContext.accept(item -> {
            item.setResult(result);
            if (this.idempotent) {
                item.setId((String)result.getOutput());
            }
            if (this.watermark) {
                item.setId((String)result.getOutput());
                item.setWatermark((Serializable)Integer.valueOf(this.pets.indexOf(result.getOutput())));
            }
        }));
        ++timesPolled;
    }

    public void onRejectedItem(Result<String, Void> result, SourceCallbackContext context) {
        ++REJECTED_ADOPTIONS;
    }

    private void resetCounters() {
        REJECTED_ADOPTIONS = 0;
        COMPLETED_POLLS = 0;
        FAILED_ADOPTION_COUNT = 0;
        ADOPTED_PET_COUNT = 0;
        timesPolled = 0;
    }

    static {
        POLLS_TO_ADD_PET = 3;
    }
}

