/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.marvel.xmen;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.inject.Inject;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.notification.Notification;
import org.mule.runtime.api.streaming.bytes.CursorStream;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.core.api.context.notification.ServerNotificationManager;
import org.mule.runtime.extension.api.annotation.execution.OnError;
import org.mule.runtime.extension.api.annotation.execution.OnSuccess;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.parameter.CorrelationInfo;
import org.mule.runtime.extension.api.runtime.source.Source;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;
import org.mule.test.marvel.xmen.MagnetoMutantNotification;
import org.mule.test.marvel.xmen.MutantUnitedResponse;

@MediaType(value="text/plain")
public class MagnetoMutantSummon
extends Source<InputStream, Void> {
    public static final String MESSAGE = "We are the future. ... You have lived in the shadows of shame and fear for too long!";
    public static final int ERROR_NOTIFICATION_ACTION = 100099;
    public static final int CLASSLOADER_NOTIFICATION_ACTION = 100101;
    @Inject
    private ServerNotificationManager notificationManager;

    public void onStart(SourceCallback<InputStream, Void> sourceCallback) throws MuleException {
        sourceCallback.handle(this.makeResult());
    }

    private Result<InputStream, Void> makeResult() {
        return Result.builder().output((Object)new ByteArrayInputStream(MESSAGE.getBytes())).build();
    }

    @OnSuccess
    public void onSuccess(@ParameterGroup(name="Response", showInDsl=true) MutantUnitedResponse mutantResponse, CorrelationInfo correlationInfo, SourceCallbackContext callbackContext) throws IOException {
        this.notifyContextClassLoader();
        if (mutantResponse.getBody().getValue() instanceof InputStream) {
            ((InputStream)mutantResponse.getBody().getValue()).read(new byte[1024]);
        }
        if (mutantResponse.getBody().getValue() instanceof CursorStreamProvider) {
            ((CursorStream)((CursorStreamProvider)mutantResponse.getBody().getValue()).openCursor()).read(new byte[1024]);
        }
    }

    @OnError
    public void onError(Error error) {
        this.notifyContextClassLoader();
        this.notificationManager.fireNotification((Notification)new MagnetoMutantNotification(error, 100099));
    }

    public void onStop() {
    }

    private void notifyContextClassLoader() {
        this.notificationManager.fireNotification((Notification)new MagnetoMutantNotification(Thread.currentThread().getContextClassLoader(), 100101));
    }
}

