/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.marvel.drstrange;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.mule.runtime.core.api.util.IOUtils;

public class MysticConnection {
    private final List<InputStream> streams = new CopyOnWriteArrayList<InputStream>();

    public InputStream manage(InputStream inputStream) {
        InputStreamWrapper managed = new InputStreamWrapper(inputStream);
        this.streams.add(managed);
        return managed;
    }

    public void close() {
        this.streams.forEach(IOUtils::closeQuietly);
    }

    private class InputStreamWrapper
    extends InputStream {
        private final InputStream delegate;
        private boolean closed = false;

        public InputStreamWrapper(InputStream delegate) {
            this.delegate = delegate;
        }

        @Override
        public int read() throws IOException {
            if (this.closed) {
                return -1;
            }
            return this.delegate.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            if (this.closed) {
                return -1;
            }
            return this.delegate.read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.closed) {
                return -1;
            }
            return this.delegate.read(b, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            return this.delegate.skip(n);
        }

        @Override
        public int available() throws IOException {
            return this.delegate.available();
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
            this.delegate.close();
        }

        @Override
        public void mark(int readlimit) {
            this.delegate.mark(readlimit);
        }

        @Override
        public void reset() throws IOException {
            this.delegate.reset();
        }

        @Override
        public boolean markSupported() {
            return this.delegate.markSupported();
        }
    }
}

