/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.server.grizzly;

import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.HttpServerFilter;
import org.glassfish.grizzly.memory.MemoryManager;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.service.http.impl.service.server.grizzly.BaseResponseCompletionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ResponseDelayedCompletionHandler
extends BaseResponseCompletionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResponseDelayedCompletionHandler.class);
    private final MemoryManager memoryManager;
    private final FilterChainContext ctx;
    private final ClassLoader ctxClassLoader;
    private final HttpResponsePacket httpResponsePacket;
    private final ResponseStatusCallback responseStatusCallback;

    ResponseDelayedCompletionHandler(FilterChainContext ctx, ClassLoader ctxClassLoader, HttpRequestPacket request, HttpResponse httpResponse, ResponseStatusCallback responseStatusCallback) {
        LOGGER.debug("Creating response sending handler for ctx: {} (delayed entity)", (Object)ctx);
        this.ctx = ctx;
        this.ctxClassLoader = ctxClassLoader;
        this.httpResponsePacket = this.buildHttpResponsePacket(request, httpResponse);
        this.memoryManager = ctx.getConnection().getTransport().getMemoryManager();
        this.responseStatusCallback = responseStatusCallback;
    }

    public Writer buildWriter(final Charset encoding) {
        return new Writer(){
            private final StringBuilder stringBuilder = new StringBuilder();

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                this.stringBuilder.append(cbuf, off, len);
            }

            @Override
            public void flush() throws IOException {
                byte[] bytes = this.stringBuilder.toString().getBytes(encoding);
                Buffer buffer = ResponseDelayedCompletionHandler.this.memoryManager.allocate(bytes.length);
                byte[] bufferByteArray = buffer.array();
                int offset = buffer.arrayOffset();
                System.arraycopy(bytes, 0, bufferByteArray, offset, bytes.length);
                this.stringBuilder.setLength(0);
                HttpContent content = ResponseDelayedCompletionHandler.this.httpResponsePacket.httpContentBuilder().last(false).content(buffer).build();
                LOGGER.debug("About to write data in delayed responder for ctx: {}", (Object)ResponseDelayedCompletionHandler.this.ctx);
                ResponseDelayedCompletionHandler.this.ctx.write((Object)content, (CompletionHandler)ResponseDelayedCompletionHandler.this);
            }

            @Override
            public void close() throws IOException {
                LOGGER.debug("Closing writer of delayed responder for ctx: {}", (Object)ResponseDelayedCompletionHandler.this.ctx);
                ResponseDelayedCompletionHandler.this.ctx.write((Object)ResponseDelayedCompletionHandler.this.httpResponsePacket.httpTrailerBuilder().build(), (CompletionHandler)ResponseDelayedCompletionHandler.this);
                ResponseDelayedCompletionHandler.this.ctx.notifyDownstream(HttpServerFilter.RESPONSE_COMPLETE_EVENT);
                ResponseDelayedCompletionHandler.this.responseStatusCallback.responseSendSuccessfully();
                ResponseDelayedCompletionHandler.this.resume();
            }
        };
    }

    public void completed(WriteResult result) {
    }

    @Override
    public void cancelled() {
        LOGGER.debug("Cancelling delayed responder for ctx: {}", (Object)this.ctx);
        super.cancelled();
        this.responseStatusCallback.responseSendFailure((Throwable)new DefaultMuleException(I18nMessageFactory.createStaticMessage((String)"HTTP response sending task was cancelled")));
        this.resume();
    }

    @Override
    public void failed(Throwable throwable) {
        LOGGER.debug("Failed on delayed responder for ctx: {}", (Object)this.ctx, (Object)throwable);
        super.failed(throwable);
        this.responseStatusCallback.onErrorSendingResponse(throwable);
        this.resume();
    }

    private void resume() {
        LOGGER.debug("Resuming ctx: {}", (Object)this.ctx);
        this.ctx.resume(this.ctx.getStopAction());
    }

    @Override
    protected ClassLoader getCtxClassLoader() {
        return this.ctxClassLoader;
    }
}

