/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.sdk.api.metadata;

import org.mule.api.annotation.Experimental;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.message.api.MessageMetadataType;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.sdk.api.annotation.DoNotEnforceMinMuleVersion;
import org.mule.sdk.api.annotation.MinMuleVersion;
import org.mule.sdk.api.metadata.resolving.ChainInputTypeResolver;

import java.util.NoSuchElementException;

/**
 * {@link MetadataContext} specialization adding information relevant to {@link ChainInputTypeResolver} instances.
 *
 * <b>NOTE:</b> Experimental feature. Backwards compatibility is not guaranteed.
 *
 * @since 0.9.0
 */
@MinMuleVersion("4.7.0")
@DoNotEnforceMinMuleVersion
@Experimental
public interface ChainInputMetadataContext extends MetadataContext {

  /**
   * Returns the resolved {@link MetadataType} from an input parameter of the owning component. This is useful when the
   * chain/route will be executed with a message that leverages said parameter's content.
   *
   * @param parameterName the name of the parameter
   * @return the parameter's resolved {@link MetadataType}
   * @throws NoSuchElementException if no parameter of that name exists in the owning component.
   */
  MetadataType getParameterResolvedType(String parameterName) throws NoSuchElementException, MetadataResolvingException;

  /**
   * @return a {@link MessageMetadataType} describing the typed message that initially entered the root component (scope/router)
   */
  MessageMetadataType getInputMessageMetadataType();

}
