/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.sdk.api.http.sse.server;

import org.mule.api.annotation.Experimental;
import org.mule.api.annotation.NoImplement;
import org.mule.sdk.api.annotation.MinMuleVersion;
import org.mule.sdk.api.http.domain.message.request.HttpRequestContext;

import java.net.InetSocketAddress;
import java.util.function.Consumer;

/**
 * Configures instances of {@link SseClient}.
 *
 * @since 0.12.0
 */
@Experimental
@NoImplement
@MinMuleVersion("4.10.0")
public interface SseClientConfigurer {

  /**
   * Configures the request context.
   *
   * @param requestContext the request context.
   * @return this configurer.
   */
  SseClientConfigurer withRequestContext(HttpRequestContext requestContext);

  /**
   * Configures the client id.
   *
   * @param clientId the client id.
   * @return this configurer.
   */
  SseClientConfigurer withClientId(String clientId);

  /**
   * Configures the remote address.
   *
   * @param remoteAddress the remote address.
   * @return this configurer.
   */
  SseClientConfigurer withRemoteAddress(InetSocketAddress remoteAddress);

  /**
   * Allows customizing the response by passing a callback.
   *
   * @param callback the callback.
   * @return this configurer.
   */
  SseClientConfigurer customizeResponse(Consumer<SseResponseCustomizer> callback);
}
