/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.sdk.api.http.protocol;

import org.mule.api.annotation.Experimental;
import org.mule.api.annotation.NoImplement;
import org.mule.sdk.api.annotation.MinMuleVersion;

/**
 * Allows enabling/disabling and configuring HTTP/1 specific parameters.
 *
 * @since 0.12.0
 */
@Experimental
@NoImplement
@MinMuleVersion("4.10.0")
public interface Http1ProtocolConfigurer {

  /**
   * Enables or disables HTTP/1 support.
   *
   * @param enabled whether it should be enabled or not. Default is {@code true}.
   * @return this configurer.
   */
  Http1ProtocolConfigurer setEnabled(boolean enabled);
}
