/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.sdk.api.http.domain.message;

import org.mule.api.annotation.Experimental;
import org.mule.api.annotation.NoImplement;
import org.mule.runtime.api.util.MultiMap;
import org.mule.sdk.api.annotation.MinMuleVersion;

import java.util.Collection;

/**
 * Generic contract for a message which contains headers
 *
 * @since 0.12.0
 */
@Experimental
@NoImplement
@MinMuleVersion("4.10.0")
public interface MessageWithHeaders {

  /**
   * @return all headers name
   */
  Collection<String> getHeaderNames();

  /**
   * @param headerName name of the header
   * @return whether the header is present in the message
   */
  default boolean containsHeader(String headerName) {
    return getHeaderValue(headerName) != null;
  }

  /**
   * @param headerName name of the header
   * @return first value of the header
   */
  String getHeaderValue(String headerName);

  /**
   * @param headerName name of the header
   * @return an immutable {@link Collection} containing all the values of that headers. If not such headers exists return null,
   *         otherwise the collection of header values
   */
  Collection<String> getHeaderValues(String headerName);

  /**
   * @return an immutable {@link MultiMap} containing all headers
   */
  MultiMap<String, String> getHeaders();
}
