/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.sdk.api.http.client.proxy;

import org.mule.api.annotation.Experimental;
import org.mule.api.annotation.NoImplement;
import org.mule.sdk.api.annotation.MinMuleVersion;
import org.mule.sdk.api.http.client.auth.HttpAuthenticationConfigurer;

import java.util.function.Consumer;

/**
 * Allows configuring the proxy parameters.
 *
 * @since 0.12.0
 */
@Experimental
@NoImplement
@MinMuleVersion("4.10.0")
public interface ProxyConfigurer {

  /**
   * Configures the host.
   *
   * @param host the host.
   * @return this configurer.
   */
  ProxyConfigurer host(String host);

  /**
   * Configures the port.
   *
   * @param port the port.
   * @return this configurer.
   */
  ProxyConfigurer port(int port);

  /**
   * Configures a set of hosts we don't want this configuration to be applied to.
   *
   * @param nonProxyHosts it's a comma-separated string.
   * @return this configurer.
   */
  ProxyConfigurer nonProxyHosts(String nonProxyHosts);

  /**
   * Allows configuring the authentication method against the proxy.
   *
   * @param authConfigurer a callback to configure the authentication.
   * @return this configurer.
   */
  ProxyConfigurer auth(Consumer<HttpAuthenticationConfigurer> authConfigurer);
}
