/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.sdk.api.http.client;

import org.mule.api.annotation.Experimental;
import org.mule.api.annotation.NoImplement;
import org.mule.sdk.api.annotation.MinMuleVersion;
import org.mule.sdk.api.http.client.auth.HttpAuthenticationConfigurer;
import org.mule.sdk.api.http.client.proxy.ProxyConfigurer;

import java.util.function.Consumer;

/**
 * Allows configuring request options.
 *
 * @since 0.12.0
 */
@Experimental
@NoImplement
@MinMuleVersion("4.10.0")
public interface HttpRequestOptionsConfigurer {

  /**
   * Sets the response timeout, in milliseconds.
   *
   * @param responseTimeout response timeout, in milliseconds.
   * @return this config.
   */
  HttpRequestOptionsConfigurer setResponseTimeout(int responseTimeout);

  /**
   * Sets whether the client has to follow the redirect internally when corresponds.
   *
   * @param followsRedirect whether the client has to follow the redirect internally when corresponds.
   * @return this config.
   */
  HttpRequestOptionsConfigurer setFollowsRedirect(boolean followsRedirect);

  /**
   * Allows setting a callback to configure the authentication.
   *
   * @param authConfigCallback a callback to configure the {@link HttpAuthenticationConfigurer}.
   * @return this config.
   */
  HttpRequestOptionsConfigurer setAuthentication(Consumer<HttpAuthenticationConfigurer> authConfigCallback);

  /**
   * Allows setting a callback to configure the proxy parameters.
   *
   * @param proxyConfigCallback a callback to configure the {@link ProxyConfigurer}.
   * @return this config.
   */
  HttpRequestOptionsConfigurer setProxyConfig(Consumer<ProxyConfigurer> proxyConfigCallback);

  /**
   * Sets whether the client has to send the request body, even when the method has no body semantics (GET, DELETE, TRACE, OPTIONS
   * and HEAD, see <a href="https://www.rfc-editor.org/rfc/rfc7231">RFC 7231</a>).
   *
   * @param sendBodyAlways whether the client has to send the request body.
   * @return this config.
   */
  HttpRequestOptionsConfigurer setSendBodyAlways(boolean sendBodyAlways);
}
