/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.sdk.api.http.client;

import static org.mule.runtime.api.i18n.I18nMessageFactory.createStaticMessage;

import org.mule.api.annotation.Experimental;
import org.mule.runtime.api.exception.MuleException;

/**
 * Exception thrown when a client cannot be created.
 *
 * @since 0.12.0
 */
@Experimental
public class ClientCreationException extends MuleException {

  private static final long serialVersionUID = -7026788269388377848L;

  public ClientCreationException(String message, Throwable cause) {
    super(createStaticMessage("Could not create client: " + message), cause);
  }

  public ClientCreationException(String message) {
    super(createStaticMessage("Could not create client: " + message));
  }

}
