/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.sdk.api.artifact.lifecycle;

import org.mule.api.annotation.Experimental;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.sdk.api.annotation.MinMuleVersion;

/**
 * Extensions are typically contained in Apps or Domains, which going forward we will refer to as <i>the enclosing artifact</i>.
 * <p>
 * This interface allows performing tasks related to the artifact's lifecycle. Notice that this is different from implementing any
 * of the {@link Lifecycle} interfaces in any of the extension's component because:
 *
 * <ul>
 * <li>An artifact can contain several instances of the same extension type, while {@link Lifecycle} is specific to each
 * instance</li>
 * <li>The component's lifecycle is either not yet started or already finished by the time the artifact's lifecycle is
 * processed</li>
 * </ul>
 * <p>
 * One of the most common use cases for this is performing cleanup that needs to happen when the enclosing artifact is undeployed.
 * For instance, some JDBC Drivers or JMS brokers are known for leaking threads and memory that require custom workarounds. This
 * listener gives the extension the chance to ship code that cleans up the right moment.
 * <p>
 * <b>NOTE:</b> Experimental feature. Backwards compatibility not guaranteed.
 *
 * @since 1.0
 */
@MinMuleVersion("4.5.0")
@Experimental
public interface ArtifactLifecycleListener {


  /**
   * Executed when the enclosing artifact is disposed.
   *
   * @param disposalContext the disposal context
   */
  void onArtifactDisposal(ArtifactDisposalContext disposalContext);

}
