/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.sdk.api.annotation.param.stereotype;

import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.PARAMETER;
import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import org.mule.sdk.api.annotation.MinMuleVersion;
import org.mule.sdk.api.runtime.route.Chain;
import org.mule.sdk.api.runtime.route.Route;
import org.mule.sdk.api.stereotype.StereotypeDefinition;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * Declares an array of {@link Class classes} of an {@link StereotypeDefinition}, to communicate and declare which
 * {@link StereotypeDefinition} the annotated component allows to be injected with.
 * <p>
 * This annotation can be applied to parameters of type {@link Chain}, or to {@link Route} implementations.
 *
 * @since 1.0
 * @see StereotypeDefinition
 * @see Chain
 * @see Route
 */
@Target({FIELD, PARAMETER, TYPE})
@Retention(RUNTIME)
@Documented
@MinMuleVersion("4.5.0")
public @interface AllowedStereotypes {

  Class<? extends StereotypeDefinition>[] value();
}
