/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.sdk.api.annotation.metadata;

import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import org.mule.api.annotation.Experimental;
import org.mule.metadata.message.api.MessageMetadataType;
import org.mule.sdk.api.annotation.DoNotEnforceMinMuleVersion;
import org.mule.sdk.api.annotation.MinMuleVersion;
import org.mule.sdk.api.metadata.resolving.OutputTypeResolver;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * Applied to scope components, specifies to the DataSense engine that the payload and attributes types that will exit the owning
 * scope component is the same one that originally exited the scope chain.
 * <p>
 * This can be considered as a shortcut of a {@link OutputTypeResolver} that returns the same {@link MessageMetadataType} that
 * exited the scope chain.
 * <p>
 * <b>NOTE:</b> Experimental feature. Backwards compatibility is not guaranteed.
 *
 * @since 0.10.0
 */
@Target({METHOD})
@Retention(RUNTIME)
@Documented
@MinMuleVersion("4.8.0")
@DoNotEnforceMinMuleVersion
@Experimental
public @interface PassThroughOutputChainResolver {
}
