/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.sdk.api.annotation;

import static java.lang.annotation.ElementType.CONSTRUCTOR;
import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * This annotation signals that the annotated component relies on a Mule Runtime feature that is only available starting with a
 * specific version.
 *
 * @since 1.0
 */
@Target({TYPE, FIELD, METHOD, CONSTRUCTOR})
@Retention(RUNTIME)
@Documented
public @interface MinMuleVersion {

  /**
   * The minimum version of the Mule Runtime that is required for the annotated component to work.
   * <p>
   * Although this is a semver version, specifying the patch number is supported but not required (e.g: 4.4, 4.5, 4.5.2)
   */
  String value();
}
