/*
 * Decompiled with CFR 0.152.
 */
package org.mule.sdk.api.store;

import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.mule.sdk.api.annotation.MinMuleVersion;

@MinMuleVersion(value="4.5.0")
public class ObjectStoreSettings {
    public static final long DEFAULT_EXPIRATION_INTERVAL = TimeUnit.MINUTES.toMillis(1L);
    private boolean persistent = true;
    private Integer maxEntries = null;
    private Long entryTTL;
    private long expirationInterval = DEFAULT_EXPIRATION_INTERVAL;

    private ObjectStoreSettings() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ObjectStoreSettings unmanagedTransient() {
        return ObjectStoreSettings.builder().persistent(false).build();
    }

    public static ObjectStoreSettings unmanagedPersistent() {
        return ObjectStoreSettings.builder().persistent(true).build();
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public Optional<Integer> getMaxEntries() {
        return Optional.ofNullable(this.maxEntries);
    }

    public Optional<Long> getEntryTTL() {
        return Optional.ofNullable(this.entryTTL);
    }

    public long getExpirationInterval() {
        return this.expirationInterval;
    }

    public static class Builder {
        private final ObjectStoreSettings product = new ObjectStoreSettings();

        private Builder() {
        }

        public Builder persistent(boolean persistent) {
            this.product.persistent = persistent;
            return this;
        }

        public Builder maxEntries(Integer maxEntries) {
            this.product.maxEntries = maxEntries;
            return this;
        }

        public Builder entryTtl(Long entryTtl) {
            this.product.entryTTL = entryTtl;
            return this;
        }

        public Builder expirationInterval(Long expirationInterval) {
            this.product.expirationInterval = expirationInterval;
            return this;
        }

        public ObjectStoreSettings build() {
            return this.product;
        }
    }
}

