/*
 * Decompiled with CFR 0.152.
 */
package org.mule.sdk.api.runtime.exception;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.mule.runtime.api.util.Reference;
import org.mule.sdk.api.annotation.MinMuleVersion;
import org.mule.sdk.api.error.ErrorTypeDefinition;
import org.mule.sdk.api.exception.ModuleException;

@MinMuleVersion(value="4.5.0")
public abstract class ExceptionHandler {
    public abstract Exception enrichException(Exception var1);

    protected Exception getRootErrorException(Exception exception) {
        Optional<ErrorTypeDefinition> error = this.getRootCauseErrorType(exception);
        return error.isPresent() ? new ModuleException(error.get(), exception) : exception;
    }

    protected <T extends Throwable> Optional<T> getCauseOfType(Throwable throwable, Class<T> causeType) {
        return this.getCauseOfType(throwable, causeType, new HashSet<Reference<Throwable>>());
    }

    private <T extends Throwable> Optional<T> getCauseOfType(Throwable throwable, Class<T> causeType, Set<Reference<Throwable>> visitedCauses) {
        if (causeType.isInstance(throwable)) {
            return Optional.of(throwable);
        }
        Throwable cause = throwable.getCause();
        if (cause != null && visitedCauses.add((Reference<Throwable>)new Reference((Object)cause))) {
            return this.getCauseOfType(cause, causeType, visitedCauses);
        }
        return Optional.empty();
    }

    private Optional<ErrorTypeDefinition> getRootCauseErrorType(Throwable exception, Optional<ErrorTypeDefinition> errorType) {
        if (exception == null) {
            return errorType;
        }
        Optional<ErrorTypeDefinition> error = exception instanceof ModuleException ? Optional.of(((ModuleException)((Object)exception)).getType()) : errorType;
        return this.getRootCauseErrorType(exception.getCause(), error);
    }

    private Optional<ErrorTypeDefinition> getRootCauseErrorType(Throwable exception) {
        return this.getRootCauseErrorType(exception, Optional.empty());
    }
}

