/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.tracer.customization.impl.provider;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.tracer.api.span.info.InitialSpanInfo;
import org.mule.runtime.tracer.customization.api.InitialSpanInfoProvider;
import org.mule.runtime.tracer.customization.impl.info.ExecutionInitialSpanInfo;
import org.mule.runtime.tracer.customization.impl.info.SpanInitialInfoUtils;
import org.mule.runtime.tracer.customization.impl.provider.InitialSpanInfoIdentifier;
import org.mule.runtime.tracer.customization.impl.provider.LazyInitialSpanInfo;
import org.mule.runtime.tracing.level.api.config.TracingLevelConfiguration;

public class DefaultInitialSpanInfoProvider
implements InitialSpanInfoProvider {
    private final Map<InitialSpanInfoIdentifier, ExecutionInitialSpanInfo> componentInitialSpanInfos = new ConcurrentHashMap<InitialSpanInfoIdentifier, ExecutionInitialSpanInfo>();
    public static final String API_ID_CONFIGURATION_PROPERTIES_KEY = "apiId";
    MuleContext muleContext;
    ConfigurationProperties configurationProperties;
    TracingLevelConfiguration tracingLevelConfiguration;
    private String apiId;
    private boolean initialisedAttributes;

    public InitialSpanInfo getInitialSpanInfo(Component component) {
        return new LazyInitialSpanInfo(() -> this.doGetInitialSpanInfo(component, null, null));
    }

    public InitialSpanInfo getInitialSpanInfo(Component component, String suffix) {
        return new LazyInitialSpanInfo(() -> this.doGetInitialSpanInfo(component, suffix, null));
    }

    public InitialSpanInfo getInitialSpanInfo(Component component, String overriddenName, String suffix) {
        return new LazyInitialSpanInfo(() -> this.doGetInitialSpanInfo(component, suffix, overriddenName));
    }

    private InitialSpanInfo doGetInitialSpanInfo(Component component, String suffix, String overriddenName) {
        if (!this.initialisedAttributes) {
            this.initialiseAttributes();
            this.initialisedAttributes = true;
        }
        if (component.getLocation() == null) {
            return new ExecutionInitialSpanInfo(component, this.apiId, overriddenName, suffix, this.tracingLevelConfiguration);
        }
        return this.componentInitialSpanInfos.computeIfAbsent(new InitialSpanInfoIdentifier(SpanInitialInfoUtils.getLocationAsString(component.getLocation()), suffix, overriddenName), identifier -> this.getExecutionInitialSpanInfo(component, suffix, overriddenName));
    }

    private ExecutionInitialSpanInfo getExecutionInitialSpanInfo(Component component, String suffix, String overriddenName) {
        ExecutionInitialSpanInfo executionInitialSpanInfo = new ExecutionInitialSpanInfo(component, this.apiId, overriddenName, suffix, this.tracingLevelConfiguration);
        this.tracingLevelConfiguration.onConfigurationChange(executionInitialSpanInfo::reconfigureInitialSpanInfo);
        return executionInitialSpanInfo;
    }

    public void initialiseAttributes() {
        if (this.muleContext.getArtifactType().equals((Object)ArtifactType.POLICY)) {
            this.apiId = this.configurationProperties.resolveStringProperty(API_ID_CONFIGURATION_PROPERTIES_KEY).orElse(null);
        }
    }

    @Inject
    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    @Inject
    public void setConfigurationProperties(ConfigurationProperties configurationProperties) {
        this.configurationProperties = configurationProperties;
    }

    @Inject
    public void setTracingLevelConfiguration(TracingLevelConfiguration tracingLevelConfiguration) {
        this.tracingLevelConfiguration = tracingLevelConfiguration;
    }

    public boolean isDynamicallyConfigurable(InitialSpanInfo initialSpanInfo) {
        return this.componentInitialSpanInfos.containsValue(initialSpanInfo);
    }
}

