/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.tracing.level.impl.config;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.tracer.exporter.config.api.SpanExporterConfiguration;
import org.mule.runtime.tracing.level.api.config.TracingLevel;
import org.mule.runtime.tracing.level.api.config.TracingLevelConfiguration;
import org.mule.runtime.tracing.level.impl.config.FileTracingLevelConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoConfigurableTracingLevelConfiguration
implements TracingLevelConfiguration,
Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AutoConfigurableTracingLevelConfiguration.class);
    private MuleContext muleContext;
    private SpanExporterConfiguration spanExporterConfiguration;
    private TracingLevelConfiguration delegate;
    private TracingLevel defaultLevel = TracingLevel.valueOf((String)System.getProperty("mule.openTelemetry.tracer.exporter.defaultTracingLevel", TracingLevel.MONITORING.toString()).toUpperCase());

    @Inject
    public AutoConfigurableTracingLevelConfiguration(MuleContext muleContext) {
        this(muleContext, new FileTracingLevelConfiguration(muleContext));
    }

    protected AutoConfigurableTracingLevelConfiguration(MuleContext muleContext, TracingLevelConfiguration delegate) {
        Objects.requireNonNull(delegate, "delegate cannot be null");
        this.muleContext = muleContext;
        this.delegate = delegate;
    }

    @Inject
    public void setSpanExporterConfiguration(SpanExporterConfiguration spanExporterConfiguration) {
        this.spanExporterConfiguration = spanExporterConfiguration;
    }

    public TracingLevel getTracingLevel() {
        return this.getTracingLevelFromDelegate(() -> this.delegate.getTracingLevel());
    }

    public TracingLevel getTracingLevelOverride(String location) {
        return this.getTracingLevelFromDelegate(() -> this.delegate.getTracingLevelOverride(location));
    }

    private TracingLevel getTracingLevelFromDelegate(Supplier<TracingLevel> tracingLevelSupplier) {
        try {
            TracingLevel level = tracingLevelSupplier.get();
            return level != null ? level : this.defaultLevel;
        }
        catch (MuleRuntimeException e) {
            if (Boolean.parseBoolean(this.spanExporterConfiguration.getStringValue("mule.openTelemetry.tracer.exporter.enabled", "false"))) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("Non existent or non parseable tracing level config file found. The tracing level will be set to the default: %s", this.defaultLevel), (Throwable)e);
                } else {
                    LOGGER.info(String.format("Non existent or non parseable tracing level config file found. The tracing level will be set to the default: %s. Enable DEBUG log level to see the exception", this.defaultLevel));
                }
            }
            return this.defaultLevel;
        }
    }

    public void onConfigurationChange(Consumer<TracingLevelConfiguration> onConfigurationChangeConsumer) {
        this.delegate.onConfigurationChange(onConfigurationChangeConsumer);
    }

    public void dispose() {
        LifecycleUtils.disposeIfNeeded((Object)this.delegate, (Logger)LOGGER);
    }
}

