/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.api.server;

import java.io.IOException;
import java.util.Collection;
import java.util.function.Consumer;
import org.mule.api.annotation.Experimental;
import org.mule.api.annotation.NoImplement;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.server.RequestHandler;
import org.mule.runtime.http.api.server.RequestHandlerManager;
import org.mule.runtime.http.api.server.ServerAddress;
import org.mule.runtime.http.api.server.ws.WebSocketHandler;
import org.mule.runtime.http.api.server.ws.WebSocketHandlerManager;
import org.mule.runtime.http.api.sse.server.SseClient;
import org.mule.runtime.http.api.sse.server.SseEndpointManager;
import org.mule.runtime.http.api.sse.server.SseRequestContext;

@NoImplement
public interface HttpServer {
    public HttpServer start() throws IOException;

    public HttpServer stop();

    public void dispose();

    public ServerAddress getServerAddress();

    public HttpConstants.Protocol getProtocol();

    public boolean isStopping();

    public boolean isStopped();

    default public void enableTls(TlsContextFactory tlsContextFactory) {
        throw new UnsupportedOperationException("TLS is not supported");
    }

    default public void disableTls() {
        throw new UnsupportedOperationException("TLS is not supported");
    }

    public RequestHandlerManager addRequestHandler(Collection<String> var1, String var2, RequestHandler var3);

    public RequestHandlerManager addRequestHandler(String var1, RequestHandler var2);

    default public WebSocketHandlerManager addWebSocketHandler(WebSocketHandler handler) {
        throw new UnsupportedOperationException("WebSockets are only supported in Enterprise Edition");
    }

    @Experimental
    default public SseEndpointManager sse(String ssePath, Consumer<SseRequestContext> onRequest, Consumer<SseClient> onClient) {
        throw new UnsupportedOperationException("Server-sent Events (SSE) are not supported in this HTTP Service version");
    }

    @Experimental
    default public SseEndpointManager sse(String ssePath, Consumer<SseClient> sseClientHandler) {
        return this.sse(ssePath, ctx -> {}, sseClientHandler);
    }
}

