/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.api.domain.entity;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import org.mule.api.annotation.NoExtend;
import org.mule.runtime.api.util.IOUtils;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.multipart.HttpPart;

@NoExtend
public class InputStreamHttpEntity
implements HttpEntity {
    private Long contentLength;
    private InputStream inputStream;

    public InputStreamHttpEntity(InputStream inputStream) {
        Objects.requireNonNull(inputStream, "HTTP entity stream cannot be null.");
        this.inputStream = inputStream;
    }

    public InputStreamHttpEntity(InputStream inputStream, Long contentLength) {
        this(inputStream);
        this.contentLength = contentLength;
    }

    @Override
    public boolean isStreaming() {
        return true;
    }

    @Override
    public boolean isComposed() {
        return false;
    }

    @Override
    public InputStream getContent() {
        return this.inputStream;
    }

    @Override
    public byte[] getBytes() throws IOException {
        return IOUtils.toByteArray((InputStream)this.inputStream);
    }

    @Override
    public Collection<HttpPart> getParts() {
        return Collections.emptyList();
    }

    @Override
    public Optional<Long> getLength() {
        return Optional.ofNullable(this.contentLength);
    }
}

