/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.api.client;

import java.util.Optional;
import org.mule.api.annotation.Experimental;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;
import org.mule.runtime.http.api.client.proxy.ProxyConfig;

@Experimental
class DefaultHttpRequestOptions
implements HttpRequestOptions {
    private int responseTimeout;
    private boolean followsRedirect;
    private HttpAuthentication authentication;
    private Boolean streamResponse;
    private ProxyConfig proxyConfig;
    private Integer responseBufferSize;

    DefaultHttpRequestOptions(int responseTimeout, boolean followsRedirect, HttpAuthentication authentication, Boolean streamResponse, Integer responseBufferSize, ProxyConfig proxyConfig) {
        this.responseTimeout = responseTimeout;
        this.followsRedirect = followsRedirect;
        this.authentication = authentication;
        this.streamResponse = streamResponse;
        this.responseBufferSize = responseBufferSize;
        this.proxyConfig = proxyConfig;
    }

    @Override
    public int getResponseTimeout() {
        return this.responseTimeout;
    }

    @Override
    public boolean isFollowsRedirect() {
        return this.followsRedirect;
    }

    @Override
    public Optional<HttpAuthentication> getAuthentication() {
        return Optional.ofNullable(this.authentication);
    }

    @Override
    public Optional<Boolean> isStreamResponse() {
        return Optional.ofNullable(this.streamResponse);
    }

    @Override
    public Optional<Integer> getResponseBufferSize() {
        return Optional.ofNullable(this.responseBufferSize);
    }

    @Override
    public Optional<ProxyConfig> getProxyConfig() {
        return Optional.ofNullable(this.proxyConfig);
    }
}

