/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.util.ComponentAstPredicatesFactory;
import org.mule.runtime.ast.api.util.MuleAstUtils;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResultItem;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;

public class ExpressionsInRequiredExpressionsParamsNonPropertyValue
implements Validation {
    private static final String CONFIGURATION_NAME = "configuration";
    protected static final ComponentIdentifier CONFIGURATION_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("configuration").build();

    public String getName() {
        return "Expression in expressionsRequired params are fixed";
    }

    public String getDescription() {
        return "Expressions are fixed for parameters that require expressions.";
    }

    public Validation.Level getLevel() {
        return Validation.Level.WARN;
    }

    public Predicate<List<ComponentAst>> applicable() {
        return ComponentAstPredicatesFactory.currentElemement(component -> component.getModel(ParameterizedModel.class).map(pmz -> pmz.getAllParameterModels()).orElse(Collections.emptyList()).stream().filter(pm -> ExpressionSupport.REQUIRED.equals((Object)pm.getExpressionSupport())).findAny().isPresent());
    }

    public List<ValidationResultItem> validateMany(ComponentAst component, ArtifactAst artifact) {
        return component.getModel(ParameterizedModel.class).map(pmz -> ExtensionModelUtils.getGroupAndParametersPairs((ParameterizedModel)pmz).filter(gnp -> ExpressionSupport.REQUIRED.equals((Object)((ParameterModel)gnp.getSecond()).getExpressionSupport())).map(gnp -> component.getParameter(((ParameterGroupModel)gnp.getFirst()).getName(), ((ParameterModel)gnp.getSecond()).getName())).collect(Collectors.toList())).orElse(Collections.emptyList()).stream().filter(param -> MuleAstUtils.hasPropertyPlaceholder((String)param.getRawValue())).map(param -> ValidationResultItem.create((ComponentAst)component, (ComponentParameterAst)param, (Validation)this, (String)String.format("Parameter '%s' has value '%s' which is resolved with a property and may cause the artifact to have different behavior on different environments.", param.getModel().getName(), param.getRawValue()))).collect(Collectors.toList());
    }
}

