/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.source.scheduler;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.source.FixedFrequencySchedulerConfiguration;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.source.scheduler.PeriodicScheduler;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;

@Alias(value="fixed-frequency")
public final class FixedFrequencyScheduler
extends PeriodicScheduler
implements FixedFrequencySchedulerConfiguration {
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Optional(defaultValue="MILLISECONDS")
    private TimeUnit timeUnit = TimeUnit.MILLISECONDS;
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Optional(defaultValue="60000")
    private long frequency = 60000L;
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Optional(defaultValue="0")
    private long startDelay = 1000L;

    public FixedFrequencyScheduler() {
    }

    public FixedFrequencyScheduler(long frequency, long startDelay, TimeUnit timeUnit) {
        this.setFrequency(frequency);
        this.setStartDelay(startDelay);
        this.setTimeUnit(timeUnit);
    }

    @Override
    public ScheduledFuture<?> doSchedule(Scheduler executor, Runnable job) {
        return executor.scheduleAtFixedRate(job, this.startDelay, this.frequency, this.timeUnit);
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public void setFrequency(long frequency) {
        Preconditions.checkArgument((frequency > 0L ? 1 : 0) != 0, (String)"Frequency must be greater then zero");
        this.frequency = frequency;
    }

    public void setStartDelay(long startDelay) {
        Preconditions.checkArgument((startDelay >= 0L ? 1 : 0) != 0, (String)"Start delay must be greater then zero");
        this.startDelay = startDelay;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public long getFrequency() {
        return this.frequency;
    }

    public long getStartDelay() {
        return this.startDelay;
    }
}

