/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.util.IOUtils;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.util.ComponentAstPredicatesFactory;
import org.mule.runtime.ast.api.util.MuleAstUtils;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResultItem;
import org.mule.runtime.config.internal.dsl.utils.DslConstants;

public class ParseTemplateResourceExist
implements Validation {
    private static final String PARSE_TEMPLATE_ELEMENT_NAME = "parse-template";
    private static final String LOCATION_PARAM = "location";
    private static final ComponentIdentifier PARSE_TEMPLATE_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").namespaceUri(DslConstants.CORE_NAMESPACE).name("parse-template").build();
    private final ClassLoader artifactRegionClassLoader;
    private final boolean ignoreParamsWithProperties;

    public ParseTemplateResourceExist(ClassLoader artifactRegionClassLoader, boolean ignoreParamsWithProperties) {
        this.artifactRegionClassLoader = artifactRegionClassLoader;
        this.ignoreParamsWithProperties = ignoreParamsWithProperties;
    }

    public String getName() {
        return "'parse-template' resources exist";
    }

    public String getDescription() {
        return "Template file referenced in 'parse-template' exists and is accessible.";
    }

    public Validation.Level getLevel() {
        return Validation.Level.ERROR;
    }

    public Predicate<List<ComponentAst>> applicable() {
        return ComponentAstPredicatesFactory.currentElemement((Predicate)ComponentAstPredicatesFactory.equalsIdentifier((ComponentIdentifier)PARSE_TEMPLATE_IDENTIFIER)).and(ComponentAstPredicatesFactory.currentElemement(component -> {
            ComponentParameterAst locationParam = component.getParameter("General", LOCATION_PARAM);
            if (this.ignoreParamsWithProperties && MuleAstUtils.hasPropertyPlaceholder((String)locationParam.getRawValue())) {
                return false;
            }
            return locationParam.getValue().getRight() != null;
        }));
    }

    public Optional<ValidationResultItem> validate(ComponentAst component, ArtifactAst artifact) {
        ComponentParameterAst locationParam = component.getParameter("General", LOCATION_PARAM);
        String location = (String)locationParam.getValue().getRight();
        if (IOUtils.getResourceAsUrl((String)location, this.getClass()) == null) {
            return Optional.of(ValidationResultItem.create((ComponentAst)component, (ComponentParameterAst)locationParam, (Validation)this, (String)("Template location: '" + location + "' not found")));
        }
        return Optional.empty();
    }
}

