/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.mule.runtime.api.util.NameValidationUtil;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.util.ComponentAstPredicatesFactory;
import org.mule.runtime.ast.api.util.MuleAstUtils;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResultItem;

public class NameHasValidCharacters
implements Validation {
    public String getName() {
        return "Names have valid characters";
    }

    public String getDescription() {
        return "'name' attribute in top-level elements only have valid characters.";
    }

    public Validation.Level getLevel() {
        return Validation.Level.ERROR;
    }

    public Predicate<List<ComponentAst>> applicable() {
        return ComponentAstPredicatesFactory.topLevelElement().and(ComponentAstPredicatesFactory.currentElemement(component -> component.getComponentId().isPresent()));
    }

    public Optional<ValidationResultItem> validate(ComponentAst component, ArtifactAst artifact) {
        String nameAttributeValue = (String)component.getComponentId().get();
        try {
            NameValidationUtil.verifyStringDoesNotContainsReservedCharacters((String)nameAttributeValue);
            return Optional.empty();
        }
        catch (IllegalArgumentException e) {
            return Optional.of(ValidationResultItem.create((ComponentAst)component, (Validation)this, (String)("Invalid global element name '" + nameAttributeValue + "'. Problem is: " + e.getMessage()), (boolean)MuleAstUtils.hasPropertyPlaceholder((String)nameAttributeValue)));
        }
    }
}

