/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import java.util.function.Predicate;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.graph.api.ArtifactAstDependencyGraphProvider;
import org.mule.runtime.ast.graph.api.ComponentAstDependency;
import org.mule.runtime.config.internal.validation.AbstractReferenceParametersStereotypesValidations;

public class ConfigReferenceParametersNonPropertyValueValidations
extends AbstractReferenceParametersStereotypesValidations {
    private final boolean enabled;

    public ConfigReferenceParametersNonPropertyValueValidations(boolean enabled, ArtifactAstDependencyGraphProvider artifactAstDependencyGraphProvider) {
        super(artifactAstDependencyGraphProvider);
        this.enabled = enabled;
    }

    public String getName() {
        return "Config Reference parameters point to fixed configs";
    }

    public String getDescription() {
        return "Config Reference parameters point to fixed configs.";
    }

    public Validation.Level getLevel() {
        return Validation.Level.WARN;
    }

    @Override
    protected boolean filterComponent(ComponentAstDependency missingDependency) {
        return super.filterComponent(missingDependency) && this.enabled && missingDependency.getName().contains("${");
    }

    @Override
    protected Predicate<? super ComponentAstDependency> filterArtifact(ArtifactAst artifact) {
        return d -> true;
    }

    @Override
    protected String validationMessage(ComponentAstDependency missing) {
        return String.format("'%s:%s' has '%s' '%s' which is resolved with a property and may cause the artifact to have different behavior on different environments.", missing.getComponent().getIdentifier().getNamespace(), missing.getComponent().getIdentifier().getName(), missing.getParameter().getModel().getName(), missing.getName());
    }
}

