/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.extension.provider;

import com.google.common.collect.ImmutableSet;
import com.google.gson.reflect.TypeToken;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.declaration.fluent.ConstructDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.FunctionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.HasParametersDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.NestedComponentDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.NestedRouteDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OptionalParameterDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterizedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclarer;
import org.mule.runtime.api.meta.model.deprecated.DeprecationModel;
import org.mule.runtime.api.meta.model.display.ClassValueModel;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.meta.model.display.PathModel;
import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.api.meta.model.error.ErrorModelBuilder;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModelBuilder;
import org.mule.runtime.api.notification.NotificationListener;
import org.mule.runtime.api.scheduler.SchedulingStrategy;
import org.mule.runtime.api.util.MuleSystemProperties;
import org.mule.runtime.core.api.error.Errors;
import org.mule.runtime.core.api.extension.provider.MuleExtensionModelProvider;
import org.mule.runtime.core.api.source.scheduler.CronScheduler;
import org.mule.runtime.core.api.source.scheduler.FixedFrequencyScheduler;
import org.mule.runtime.core.internal.extension.AllowsExpressionWithoutMarkersModelProperty;
import org.mule.runtime.core.internal.extension.CustomBuildingDefinitionProviderModelProperty;
import org.mule.runtime.core.privileged.extension.SingletonModelProperty;
import org.mule.runtime.extension.api.ExtensionConstants;
import org.mule.runtime.extension.api.declaration.type.DynamicConfigExpirationTypeBuilder;
import org.mule.runtime.extension.api.declaration.type.annotation.TypeDslAnnotation;
import org.mule.runtime.extension.api.error.ErrorConstants;
import org.mule.runtime.extension.api.model.deprecated.ImmutableDeprecationModel;
import org.mule.runtime.extension.api.property.NoRedeliveryPolicyModelProperty;
import org.mule.runtime.extension.api.property.NoWrapperModelProperty;
import org.mule.runtime.extension.api.property.SinceMuleVersionModelProperty;
import org.mule.runtime.extension.api.stereotype.MuleStereotypes;
import org.mule.runtime.extension.internal.loader.util.InfrastructureParameterBuilder;
import org.mule.runtime.extension.internal.property.NoErrorMappingModelProperty;
import org.mule.runtime.extension.internal.property.TargetModelProperty;
import org.mule.runtime.internal.dsl.DslConstants;

class MuleExtensionModelDeclarer {
    static final String DEFAULT_LOG_LEVEL = "INFO";
    private static final ClassValueModel NOTIFICATION_CLASS_VALUE_MODEL = new ClassValueModel(Collections.singletonList(NotificationListener.class.getName()));
    final ErrorModel anyError = ErrorModelBuilder.newError((ComponentIdentifier)Errors.ComponentIdentifiers.Handleable.ANY).build();
    final ErrorModel routingError = ErrorModelBuilder.newError((ComponentIdentifier)Errors.ComponentIdentifiers.Handleable.ROUTING).withParent(this.anyError).build();
    final ErrorModel compositeRoutingError = ErrorModelBuilder.newError((ComponentIdentifier)Errors.ComponentIdentifiers.Handleable.COMPOSITE_ROUTING).withParent(this.routingError).build();
    final ErrorModel validationError = ErrorModelBuilder.newError((ComponentIdentifier)Errors.ComponentIdentifiers.Handleable.VALIDATION).withParent(this.anyError).build();
    final ErrorModel duplicateMessageError = ErrorModelBuilder.newError((ComponentIdentifier)Errors.ComponentIdentifiers.Handleable.DUPLICATE_MESSAGE).withParent(this.validationError).build();
    final ErrorModel transactionError = ErrorModelBuilder.newError((ComponentIdentifier)Errors.ComponentIdentifiers.Handleable.TRANSACTION).withParent(this.anyError).build();

    MuleExtensionModelDeclarer() {
    }

    ExtensionDeclarer createExtensionModel() {
        ExtensionDeclarer extensionDeclarer = new ExtensionDeclarer().named("mule").describedAs("Mule Runtime and Integration Platform: Core components").onVersion(MuleExtensionModelProvider.MULE_VERSION).fromVendor("MuleSoft, Inc.").withCategory(Category.COMMUNITY).supportingJavaVersions(ExtensionConstants.ALL_SUPPORTED_JAVA_VERSIONS).withModelProperty((ModelProperty)new CustomBuildingDefinitionProviderModelProperty()).withXmlDsl(XmlDslModel.builder().setPrefix("mule").setNamespace(DslConstants.CORE_NAMESPACE).setSchemaVersion(MuleExtensionModelProvider.MULE_VERSION).setXsdFileName("mule.xsd").setSchemaLocation(DslConstants.CORE_SCHEMA_LOCATION).build());
        this.declareExportedTypes(extensionDeclarer);
        this.declareObject(extensionDeclarer);
        this.declareFlow(extensionDeclarer);
        this.declareSubflow(extensionDeclarer);
        this.declareChoice(extensionDeclarer);
        this.declareErrorHandler(extensionDeclarer);
        this.declareTry(extensionDeclarer);
        this.declareScatterGather(extensionDeclarer, MuleExtensionModelProvider.TYPE_LOADER);
        this.declareParallelForEach(extensionDeclarer, MuleExtensionModelProvider.TYPE_LOADER);
        this.declareFirstSuccessful(extensionDeclarer);
        this.declareRoundRobin(extensionDeclarer);
        this.declareConfiguration(extensionDeclarer);
        this.declareConfigurationProperties(extensionDeclarer);
        this.declareAsync(extensionDeclarer);
        this.declareForEach(extensionDeclarer, MuleExtensionModelProvider.TYPE_LOADER);
        this.declareUntilSuccessful(extensionDeclarer);
        this.declareSecurityFilter(extensionDeclarer);
        this.declareFlowRef(extensionDeclarer);
        this.declareIdempotentValidator(extensionDeclarer);
        this.declareLogger(extensionDeclarer);
        this.declareSetPayload(extensionDeclarer);
        this.declareSetVariable(extensionDeclarer);
        this.declareRemoveVariable(extensionDeclarer);
        this.declareParseTemplate(extensionDeclarer);
        this.declareRaiseError(extensionDeclarer);
        this.declareScheduler(extensionDeclarer);
        this.declareErrors(extensionDeclarer);
        this.declareFunctions(extensionDeclarer);
        this.declareNotifications(extensionDeclarer);
        this.declareGlobalProperties(extensionDeclarer);
        this.declareSecurityManager(extensionDeclarer, MuleExtensionModelProvider.TYPE_LOADER);
        return extensionDeclarer;
    }

    private void declareObject(ExtensionDeclarer extensionDeclarer) {
        ConstructDeclarer object = (ConstructDeclarer)((ConstructDeclarer)((ConstructDeclarer)extensionDeclarer.withConstruct("object").allowingTopLevelDefinition().withStereotype(StereotypeModelBuilder.newStereotype((String)"OBJECT", (String)"MULE").withParent(MuleStereotypes.APP_CONFIG).build())).describedAs("Element to declare a java object. Objects declared globally can be referenced from other parts of the configuration or recovered programmatically through org.mule.runtime.api.artifact.Registry.")).withDeprecation((DeprecationModel)new ImmutableDeprecationModel("Only meant to be used for backwards compatibility.", "4.0", "5.0"));
        object.onDefaultParameterGroup().withRequiredParameter("name").asComponentId().ofType(MuleExtensionModelProvider.STRING_TYPE).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED).describedAs("Name to use to reference this object.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)object.onDefaultParameterGroup().withOptionalParameter("ref").ofType(MuleExtensionModelProvider.STRING_TYPE)).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("@Deprecated since 4.0. Only meant to be used for backwards compatibility. Reference to another object defined in the mule configuration or any other provider of objects.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)object.onDefaultParameterGroup().withOptionalParameter("class").ofType(MuleExtensionModelProvider.STRING_TYPE)).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("Creates an instance of the class provided as argument.");
        object.onDefaultParameterGroup().withExclusiveOptionals((Set)ImmutableSet.of((Object)"ref", (Object)"class"), true);
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)object.onDefaultParameterGroup().withOptionalParameter("property").ofType((MetadataType)BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).objectType().with((TypeAnnotation)new ClassInformationAnnotation(Map.class, Arrays.asList(String.class, String.class))).openWith(MuleExtensionModelProvider.STRING_TYPE).build())).withDsl(ParameterDslConfiguration.builder().allowsInlineDefinition(true).allowsReferences(false).build())).withModelProperty((ModelProperty)new NoWrapperModelProperty());
    }

    private void declareExportedTypes(ExtensionDeclarer extensionDeclarer) {
        ((ExtensionDeclaration)extensionDeclarer.getDeclaration()).addType((ObjectType)MuleExtensionModelProvider.OBJECT_STORE_TYPE);
    }

    private void declareScheduler(ExtensionDeclarer extensionDeclarer) {
        SourceDeclarer scheduler = (SourceDeclarer)((SourceDeclarer)extensionDeclarer.withMessageSource("scheduler").hasResponse(false).describedAs("Source that schedules periodic execution of a flow.")).withModelProperty((ModelProperty)NoRedeliveryPolicyModelProperty.INSTANCE);
        scheduler.withOutput().ofType(MuleExtensionModelProvider.ANY_TYPE);
        scheduler.withOutputAttributes().ofType(MuleExtensionModelProvider.ANY_TYPE);
        scheduler.onDefaultParameterGroup().withRequiredParameter("schedulingStrategy").ofType(this.buildSchedulingStrategyType(extensionDeclarer, MuleExtensionModelProvider.TYPE_LOADER)).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED).withDsl(ParameterDslConfiguration.builder().allowsReferences(false).allowsInlineDefinition(true).allowTopLevelDefinition(false).build());
        ((OptionalParameterDeclarer)scheduler.onDefaultParameterGroup().withOptionalParameter("disallowConcurrentExecution").ofType(MuleExtensionModelProvider.BOOLEAN_TYPE)).defaultingTo((Object)false).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
    }

    private MetadataType buildSchedulingStrategyType(ExtensionDeclarer extensionDeclarer, ClassTypeLoader typeLoader) {
        MetadataType baseSchedulingStrategy = typeLoader.load(SchedulingStrategy.class);
        MetadataType fixedFrequencyScheduler = typeLoader.load(FixedFrequencyScheduler.class);
        MetadataType cronScheduler = typeLoader.load(CronScheduler.class);
        extensionDeclarer.withSubType(baseSchedulingStrategy, fixedFrequencyScheduler);
        extensionDeclarer.withSubType(baseSchedulingStrategy, cronScheduler);
        ((ExtensionDeclaration)extensionDeclarer.getDeclaration()).addType((ObjectType)baseSchedulingStrategy);
        ((ExtensionDeclaration)extensionDeclarer.getDeclaration()).addType((ObjectType)fixedFrequencyScheduler);
        ((ExtensionDeclaration)extensionDeclarer.getDeclaration()).addType((ObjectType)cronScheduler);
        return baseSchedulingStrategy;
    }

    private void declareIdempotentValidator(ExtensionDeclarer extensionDeclarer) {
        OperationDeclarer validator = (OperationDeclarer)((OperationDeclarer)extensionDeclarer.withOperation("idempotentMessageValidator").describedAs("Ensures that only unique messages are received by a service by checking the unique ID of the incoming message. Note that the ID used can be generated from the message using an expression defined in the 'idExpression' attribute. Otherwise, a 'DUPLICATE_MESSAGE' error is generated.")).withModelProperty((ModelProperty)new NoErrorMappingModelProperty());
        validator.withOutput().ofType(MuleExtensionModelProvider.VOID_TYPE);
        validator.withOutputAttributes().ofType(MuleExtensionModelProvider.VOID_TYPE);
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)validator.onDefaultParameterGroup().withOptionalParameter("idExpression").ofType(MuleExtensionModelProvider.STRING_TYPE)).defaultingTo((Object)"#[correlationId]").withDsl(ParameterDslConfiguration.builder().allowsReferences(false).build())).describedAs("The expression to use when extracting the ID from the message. If this property is not set, '#[correlationId]' will be used by default.");
        ((OptionalParameterDeclarer)validator.onDefaultParameterGroup().withOptionalParameter("valueExpression").ofType(MuleExtensionModelProvider.STRING_TYPE)).defaultingTo((Object)"#[correlationId]").describedAs("The expression to use when extracting the value from the message.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)validator.onDefaultParameterGroup().withOptionalParameter("storePrefix").ofType(MuleExtensionModelProvider.STRING_TYPE)).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("Defines the prefix of the object store names. This will only be used for the internally built object store.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)validator.onDefaultParameterGroup().withOptionalParameter("objectStore").withDsl(ParameterDslConfiguration.builder().allowsInlineDefinition(true).allowsReferences(true).build())).ofType(MuleExtensionModelProvider.OBJECT_STORE_TYPE)).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).withAllowedStereotypes(Collections.singletonList(MuleStereotypes.OBJECT_STORE))).describedAs("The object store where the IDs of the processed events are going to be stored. If defined as an argument, it should reference a globally created object store. Otherwise, it can be defined inline or not at all. In the last case, a default object store will be provided.");
        validator.withErrorModel(this.duplicateMessageError);
    }

    private void declareAsync(ExtensionDeclarer extensionDeclarer) {
        ConstructDeclarer async = (ConstructDeclarer)extensionDeclarer.withConstruct("async").describedAs("Processes the nested list of message processors asynchronously.");
        async.withChain().withModelProperty((ModelProperty)NoWrapperModelProperty.INSTANCE);
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)async.onDefaultParameterGroup().withOptionalParameter("name").withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).ofType(MuleExtensionModelProvider.STRING_TYPE)).describedAs("Name that will be used to identify the async scheduling tasks.");
        ((OptionalParameterDeclarer)async.onDefaultParameterGroup().withOptionalParameter("maxConcurrency").describedAs("The maximum concurrency. This value determines the maximum level of parallelism that this async router can use to optimize its performance when processing messages.")).ofType(MuleExtensionModelProvider.INTEGER_TYPE);
    }

    private void declareFlowRef(ExtensionDeclarer extensionDeclarer) {
        OperationDeclarer flowRef = (OperationDeclarer)((OperationDeclarer)((OperationDeclarer)extensionDeclarer.withOperation("flowRef").describedAs("Allows a 'flow' to be referenced so that message processing will continue in the referenced flow before returning. Message processing in the referenced 'flow' will occur within the context of the referenced flow and will therefore use its error handler etc.")).withErrorModel(this.routingError)).withModelProperty((ModelProperty)new NoErrorMappingModelProperty());
        flowRef.withOutput().ofType(MuleExtensionModelProvider.ANY_TYPE);
        flowRef.withOutputAttributes().ofType(MuleExtensionModelProvider.ANY_TYPE);
        flowRef.onDefaultParameterGroup().withRequiredParameter("name").ofType(MuleExtensionModelProvider.STRING_TYPE).withAllowedStereotypes(Arrays.asList(MuleStereotypes.FLOW, MuleStereotypes.SUB_FLOW)).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED).describedAs("The name of the flow to call");
    }

    private void declareLogger(ExtensionDeclarer extensionDeclarer) {
        OperationDeclarer logger = (OperationDeclarer)((OperationDeclarer)extensionDeclarer.withOperation("logger").describedAs("Performs logging using an expression to determine the message to be logged. By default, if a message is not specified, the current Mule Message is logged using the INFO level to the 'org.mule.runtime.core.api.processor.LoggerMessageProcessor' category but the level and category can both be configured to suit your needs.")).withModelProperty((ModelProperty)new NoErrorMappingModelProperty());
        logger.withOutput().ofType(MuleExtensionModelProvider.VOID_TYPE);
        logger.withOutputAttributes().ofType(MuleExtensionModelProvider.VOID_TYPE);
        ((OptionalParameterDeclarer)logger.onDefaultParameterGroup().withOptionalParameter("message").ofType(MuleExtensionModelProvider.STRING_TYPE)).describedAs("The message that will be logged. Embedded expressions can be used to extract values from the current message. If no message is specified, then the current message is used.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)logger.onDefaultParameterGroup().withOptionalParameter("level").defaultingTo((Object)DEFAULT_LOG_LEVEL).ofType((MetadataType)MuleExtensionModelProvider.BASE_TYPE_BUILDER.stringType().enumOf(new String[]{"ERROR", "WARN", DEFAULT_LOG_LEVEL, "DEBUG", "TRACE"}).build())).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("Sets the log level. Default is INFO.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)logger.onDefaultParameterGroup().withOptionalParameter("category").ofType(MuleExtensionModelProvider.STRING_TYPE)).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("Sets the log category.");
    }

    private void declareSetPayload(ExtensionDeclarer extensionDeclarer) {
        OperationDeclarer setPayload = (OperationDeclarer)((OperationDeclarer)extensionDeclarer.withOperation("setPayload").describedAs("A processor that sets the payload with the provided value.")).withModelProperty((ModelProperty)new NoErrorMappingModelProperty());
        setPayload.withOutput().ofType(MuleExtensionModelProvider.VOID_TYPE);
        setPayload.withOutputAttributes().ofType(MuleExtensionModelProvider.VOID_TYPE);
        setPayload.onDefaultParameterGroup().withRequiredParameter("value").ofType(MuleExtensionModelProvider.STRING_TYPE).withExpressionSupport(ExpressionSupport.SUPPORTED).describedAs("The value to be set on the payload. Supports expressions.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)setPayload.onDefaultParameterGroup().withOptionalParameter("encoding").ofType(MuleExtensionModelProvider.STRING_TYPE)).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("The encoding of the value assigned to the payload.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)setPayload.onDefaultParameterGroup().withOptionalParameter("mimeType").ofType(MuleExtensionModelProvider.STRING_TYPE)).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("The mime type, e.g. text/plain or application/json");
    }

    private void declareSetVariable(ExtensionDeclarer extensionDeclarer) {
        OperationDeclarer setVariable = (OperationDeclarer)((OperationDeclarer)extensionDeclarer.withOperation("setVariable").describedAs("A processor that adds variables.")).withModelProperty((ModelProperty)new NoErrorMappingModelProperty());
        setVariable.withOutput().ofType(MuleExtensionModelProvider.VOID_TYPE);
        setVariable.withOutputAttributes().ofType(MuleExtensionModelProvider.VOID_TYPE);
        if (Boolean.getBoolean("mule.revertSupportExpressionsInVariableNameInSetVariable")) {
            ((OptionalParameterDeclarer)((OptionalParameterDeclarer)setVariable.onDefaultParameterGroup().withOptionalParameter("variableName").ofType(MuleExtensionModelProvider.STRING_TYPE)).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("The name of the variable.");
        } else {
            ((OptionalParameterDeclarer)((OptionalParameterDeclarer)setVariable.onDefaultParameterGroup().withOptionalParameter("variableName").ofType(MuleExtensionModelProvider.STRING_TYPE)).withExpressionSupport(ExpressionSupport.SUPPORTED)).describedAs("The name of the variable.");
        }
        setVariable.onDefaultParameterGroup().withRequiredParameter("value").ofType(MuleExtensionModelProvider.STRING_TYPE).withExpressionSupport(ExpressionSupport.SUPPORTED).describedAs("The value assigned to the variable. Supports expressions.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)setVariable.onDefaultParameterGroup().withOptionalParameter("encoding").ofType(MuleExtensionModelProvider.STRING_TYPE)).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("The encoding of the value assigned to the variable.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)setVariable.onDefaultParameterGroup().withOptionalParameter("mimeType").ofType(MuleExtensionModelProvider.STRING_TYPE)).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("The mime type of the value assigned to the variable, e.g. text/plain or application/json");
    }

    private void declareParseTemplate(ExtensionDeclarer extensionDeclarer) {
        OperationDeclarer parseTemplate = (OperationDeclarer)((OperationDeclarer)extensionDeclarer.withOperation("parseTemplate").describedAs("Parses a template defined inline.")).withModelProperty((ModelProperty)new NoErrorMappingModelProperty());
        parseTemplate.withOutput().ofType(MuleExtensionModelProvider.ANY_TYPE);
        parseTemplate.withOutputAttributes().ofType(MuleExtensionModelProvider.VOID_TYPE);
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)parseTemplate.onDefaultParameterGroup().withOptionalParameter("content").ofType(MuleExtensionModelProvider.STRING_TYPE)).withRole(ParameterRole.PRIMARY_CONTENT)).withExpressionSupport(ExpressionSupport.SUPPORTED)).describedAs("Template to be processed.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)parseTemplate.onDefaultParameterGroup().withOptionalParameter("location").ofType(MuleExtensionModelProvider.STRING_TYPE)).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("The location of the template. The order in which the processor will attempt to load the file is: from the file system, from a URL, then from the classpath.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)parseTemplate.onDefaultParameterGroup().withOptionalParameter("outputEncoding").ofType(MuleExtensionModelProvider.STRING_TYPE)).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("The encoding to be assigned to the result generated when parsing the template.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)parseTemplate.onDefaultParameterGroup().withOptionalParameter("outputMimeType").ofType(MuleExtensionModelProvider.STRING_TYPE)).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("The mime type to be assigned to the result generated when parsing the template, e.g. text/plain or application/json");
        if (MuleSystemProperties.isParseTemplateUseLegacyDefaultTargetValue()) {
            ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)parseTemplate.onParameterGroup("Output").withOptionalParameter("targetValue").ofType(MuleExtensionModelProvider.STRING_TYPE)).defaultingTo((Object)"#[message]").withExpressionSupport(ExpressionSupport.REQUIRED)).describedAs("An expression that will be evaluated against the operation's output and the outcome of that expression will be stored in the target variable")).withRole(ParameterRole.BEHAVIOUR)).withDisplayModel(DisplayModel.builder().displayName("Target Value").build())).withLayout(LayoutModel.builder().tabName("Advanced").build())).withModelProperty((ModelProperty)new TargetModelProperty());
        }
        parseTemplate.onDefaultParameterGroup().withExclusiveOptionals((Set)ImmutableSet.of((Object)"content", (Object)"location"), true);
    }

    private void declareRemoveVariable(ExtensionDeclarer extensionDeclarer) {
        OperationDeclarer removeVariable = (OperationDeclarer)((OperationDeclarer)extensionDeclarer.withOperation("removeVariable").describedAs("A processor that removes variables by name or a wildcard expression.")).withModelProperty((ModelProperty)new NoErrorMappingModelProperty());
        removeVariable.withOutput().ofType(MuleExtensionModelProvider.VOID_TYPE);
        removeVariable.withOutputAttributes().ofType(MuleExtensionModelProvider.VOID_TYPE);
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)removeVariable.onDefaultParameterGroup().withOptionalParameter("variableName").ofType(MuleExtensionModelProvider.STRING_TYPE)).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("The variable name.");
    }

    private void declareRaiseError(ExtensionDeclarer extensionDeclarer) {
        OperationDeclarer raiseError = (OperationDeclarer)((OperationDeclarer)extensionDeclarer.withOperation("raiseError").describedAs("Throws an error with the specified type and description.")).withModelProperty((ModelProperty)new NoErrorMappingModelProperty());
        raiseError.withOutput().ofType(MuleExtensionModelProvider.VOID_TYPE);
        raiseError.withOutputAttributes().ofType(MuleExtensionModelProvider.VOID_TYPE);
        raiseError.onDefaultParameterGroup().withRequiredParameter("type").ofType(ErrorConstants.ERROR_TYPE_DEFINITION).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED).describedAs("The error type to raise.");
        ((OptionalParameterDeclarer)raiseError.onDefaultParameterGroup().withOptionalParameter("description").ofType(MuleExtensionModelProvider.STRING_TYPE)).describedAs("The description of this error.");
    }

    private void declareForEach(ExtensionDeclarer extensionDeclarer, ClassTypeLoader typeLoader) {
        ConstructDeclarer forEach = (ConstructDeclarer)extensionDeclarer.withConstruct("foreach").describedAs("The foreach Processor allows iterating over a collection payload, or any collection obtained by an expression, generating a message for each element.");
        forEach.withChain().withModelProperty((ModelProperty)NoWrapperModelProperty.INSTANCE);
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)forEach.onDefaultParameterGroup().withOptionalParameter("collection").ofType(typeLoader.load(new TypeToken<Iterable<Object>>(){}.getType()))).defaultingTo((Object)"#[payload]").withExpressionSupport(ExpressionSupport.REQUIRED)).describedAs("Expression that defines the collection to iterate over.")).withModelProperty((ModelProperty)new AllowsExpressionWithoutMarkersModelProperty());
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)forEach.onDefaultParameterGroup().withOptionalParameter("batchSize").ofType(MuleExtensionModelProvider.INTEGER_TYPE)).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("Partitions the collection in sub-collections of the specified size.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)forEach.onDefaultParameterGroup().withOptionalParameter("rootMessageVariableName").ofType(MuleExtensionModelProvider.STRING_TYPE)).defaultingTo((Object)"rootMessage").withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("Variable name for the original message.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)forEach.onDefaultParameterGroup().withOptionalParameter("counterVariableName").ofType(MuleExtensionModelProvider.STRING_TYPE)).defaultingTo((Object)"counter").withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("Variable name for the item number being processed.");
    }

    private void declareUntilSuccessful(ExtensionDeclarer extensionDeclarer) {
        ConstructDeclarer untilSuccessful = (ConstructDeclarer)extensionDeclarer.withConstruct("untilSuccessful").describedAs("Attempts to route a message to its inner chain in a synchronous manner. Routing is considered successful if no error has been raised and, optionally, if the response matches an expression.");
        untilSuccessful.withChain().withModelProperty((ModelProperty)NoWrapperModelProperty.INSTANCE);
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)untilSuccessful.onDefaultParameterGroup().withOptionalParameter("maxRetries").ofType(MuleExtensionModelProvider.INTEGER_TYPE)).defaultingTo((Object)5).withExpressionSupport(ExpressionSupport.SUPPORTED)).describedAs("Specifies the maximum number of processing retries that will be performed.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)untilSuccessful.onDefaultParameterGroup().withOptionalParameter("millisBetweenRetries").ofType(MuleExtensionModelProvider.INTEGER_TYPE)).defaultingTo((Object)60000).withExpressionSupport(ExpressionSupport.SUPPORTED)).describedAs("Specifies the minimum time interval between two process retries in milliseconds.\n The actual time interval depends on the previous execution but should not exceed twice this number.\n Default value is 60000 (one minute)");
    }

    private void declareChoice(ExtensionDeclarer extensionDeclarer) {
        ConstructDeclarer choice = (ConstructDeclarer)((ConstructDeclarer)extensionDeclarer.withConstruct("choice").describedAs("Sends the message to the first message processor whose condition is satisfied. If none of the conditions are satisfied, it sends the message to the configured default message processor or fails if there is none.")).withErrorModel(this.routingError);
        NestedRouteDeclarer when = choice.withRoute("when").withMinOccurs(1);
        when.withChain().withModelProperty((ModelProperty)NoWrapperModelProperty.INSTANCE);
        when.onDefaultParameterGroup().withRequiredParameter("expression").ofType(MuleExtensionModelProvider.BOOLEAN_TYPE).withModelProperty((ModelProperty)new AllowsExpressionWithoutMarkersModelProperty()).describedAs("The expression to evaluate.");
        choice.withRoute("otherwise").withMaxOccurs(Integer.valueOf(1)).withChain().withModelProperty((ModelProperty)NoWrapperModelProperty.INSTANCE);
    }

    private void declareFlow(ExtensionDeclarer extensionDeclarer) {
        ConstructDeclarer flow = (ConstructDeclarer)extensionDeclarer.withConstruct("flow").allowingTopLevelDefinition().withStereotype(MuleStereotypes.FLOW);
        flow.onDefaultParameterGroup().withRequiredParameter("name").asComponentId().ofType(MuleExtensionModelProvider.STRING_TYPE);
        flow.onDefaultParameterGroup().withOptionalParameter("initialState").defaultingTo((Object)"started").ofType((MetadataType)MuleExtensionModelProvider.BASE_TYPE_BUILDER.stringType().enumOf(new String[]{"started", "stopped"}).build());
        ((OptionalParameterDeclarer)flow.onDefaultParameterGroup().withOptionalParameter("maxConcurrency").describedAs("The maximum concurrency. This value determines the maximum level of parallelism that the Flow can use to optimize its performance when processing messages.")).ofType(MuleExtensionModelProvider.INTEGER_TYPE);
        flow.withOptionalComponent("source").withAllowedStereotypes(new StereotypeModel[]{MuleStereotypes.SOURCE});
        flow.withChain().setRequired(true).withAllowedStereotypes(new StereotypeModel[]{MuleStereotypes.PROCESSOR}).withModelProperty((ModelProperty)NoWrapperModelProperty.INSTANCE);
        flow.withComponent("errorHandler").withAllowedStereotypes(new StereotypeModel[]{MuleStereotypes.ERROR_HANDLER});
    }

    private void declareSubflow(ExtensionDeclarer extensionDeclarer) {
        ConstructDeclarer subFlow = (ConstructDeclarer)extensionDeclarer.withConstruct("subFlow").allowingTopLevelDefinition().withStereotype(MuleStereotypes.SUB_FLOW);
        subFlow.onDefaultParameterGroup().withRequiredParameter("name").asComponentId().ofType(MuleExtensionModelProvider.STRING_TYPE);
        subFlow.withChain().setRequired(true).withAllowedStereotypes(new StereotypeModel[]{MuleStereotypes.PROCESSOR}).withModelProperty((ModelProperty)NoWrapperModelProperty.INSTANCE);
    }

    private void declareFirstSuccessful(ExtensionDeclarer extensionDeclarer) {
        ConstructDeclarer firstSuccessful = (ConstructDeclarer)extensionDeclarer.withConstruct("firstSuccessful").describedAs("Sends a message to a list of message processors until one processes it successfully.");
        firstSuccessful.withRoute("route").withChain().withModelProperty((ModelProperty)NoWrapperModelProperty.INSTANCE);
    }

    private void declareRoundRobin(ExtensionDeclarer extensionDeclarer) {
        ConstructDeclarer roundRobin = (ConstructDeclarer)extensionDeclarer.withConstruct("roundRobin").describedAs("Send each message received to the next message processor in a circular list of targets.");
        roundRobin.withRoute("route").withMinOccurs(1).withChain().withModelProperty((ModelProperty)NoWrapperModelProperty.INSTANCE);
    }

    private void declareScatterGather(ExtensionDeclarer extensionDeclarer, ClassTypeLoader typeLoader) {
        ConstructDeclarer scatterGather = (ConstructDeclarer)((ConstructDeclarer)extensionDeclarer.withConstruct("scatterGather").describedAs("Sends the same message to multiple message processors in parallel.")).withErrorModel(this.compositeRoutingError);
        scatterGather.withRoute("route").withMinOccurs(2).withChain().withModelProperty((ModelProperty)NoWrapperModelProperty.INSTANCE);
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)scatterGather.onDefaultParameterGroup().withOptionalParameter("timeout").ofType(typeLoader.load(Long.class))).defaultingTo((Object)Long.MAX_VALUE).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("Sets a timeout in milliseconds for each route. Values lower or equals than zero means no timeout.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)scatterGather.onDefaultParameterGroup().withOptionalParameter("maxConcurrency").ofType(MuleExtensionModelProvider.INTEGER_TYPE)).defaultingTo((Object)Integer.MAX_VALUE).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("This value determines the maximum level of parallelism that will be used by this router.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)scatterGather.onParameterGroup("Aggregation").withOptionalParameter("collectList").withRole(ParameterRole.BEHAVIOUR)).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).ofType((MetadataType)BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).objectType().id("CollectList").with((TypeAnnotation)new TypeDslAnnotation(true, false, null, null)).build())).withDsl(ParameterDslConfiguration.builder().allowsInlineDefinition(true).allowsReferences(false).allowTopLevelDefinition(false).build())).describedAs("Strategy that determines that the results are aggregated in a list rather than on a map.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)scatterGather.onParameterGroup("Output").withOptionalParameter("target").ofType(MuleExtensionModelProvider.STRING_TYPE)).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("The name of a variable on which the operation's output will be placed")).withLayout(LayoutModel.builder().tabName("Advanced").build());
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)scatterGather.onParameterGroup("Output").withOptionalParameter("targetValue").ofType(MuleExtensionModelProvider.STRING_TYPE)).defaultingTo((Object)"#[payload]").withExpressionSupport(ExpressionSupport.REQUIRED)).describedAs("An expression that will be evaluated against the operation's output and the outcome of that expression will be stored in the target variable")).withRole(ParameterRole.BEHAVIOUR)).withDisplayModel(DisplayModel.builder().displayName("Target Value").build())).withLayout(LayoutModel.builder().tabName("Advanced").build())).withModelProperty((ModelProperty)new TargetModelProperty());
    }

    private void declareParallelForEach(ExtensionDeclarer extensionDeclarer, ClassTypeLoader typeLoader) {
        ConstructDeclarer parallelForeach = (ConstructDeclarer)((ConstructDeclarer)((ConstructDeclarer)extensionDeclarer.withConstruct("parallelForeach").describedAs("Splits the same message and processes each part in parallel.")).withErrorModel(this.compositeRoutingError)).withModelProperty((ModelProperty)new SinceMuleVersionModelProperty("4.2.0"));
        parallelForeach.withChain().withModelProperty((ModelProperty)NoWrapperModelProperty.INSTANCE);
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)parallelForeach.onDefaultParameterGroup().withOptionalParameter("collection").ofType(typeLoader.load(new TypeToken<Iterable<Object>>(){}.getType()))).withRole(ParameterRole.BEHAVIOUR)).withExpressionSupport(ExpressionSupport.REQUIRED)).defaultingTo((Object)"#[payload]").withModelProperty((ModelProperty)new AllowsExpressionWithoutMarkersModelProperty()).describedAs("Expression that defines the collection of parts to be processed in parallel.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)parallelForeach.onDefaultParameterGroup().withOptionalParameter("timeout").ofType(typeLoader.load(Long.class))).defaultingTo((Object)Long.MAX_VALUE).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("Sets a timeout in milliseconds for each route. Values lower or equals than zero means no timeout.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)parallelForeach.onDefaultParameterGroup().withOptionalParameter("maxConcurrency").ofType(MuleExtensionModelProvider.INTEGER_TYPE)).defaultingTo((Object)Integer.MAX_VALUE).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("This value determines the maximum level of parallelism that will be used by this router.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)parallelForeach.onParameterGroup("Output").withOptionalParameter("target").ofType(MuleExtensionModelProvider.STRING_TYPE)).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("The name of a variable on which the operation's output will be placed")).withLayout(LayoutModel.builder().tabName("Advanced").build());
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)parallelForeach.onParameterGroup("Output").withOptionalParameter("targetValue").ofType(MuleExtensionModelProvider.STRING_TYPE)).defaultingTo((Object)"#[payload]").withExpressionSupport(ExpressionSupport.REQUIRED)).describedAs("An expression that will be evaluated against the operation's output and the outcome of that expression will be stored in the target variable")).withRole(ParameterRole.BEHAVIOUR)).withDisplayModel(DisplayModel.builder().displayName("Target Value").build())).withLayout(LayoutModel.builder().tabName("Advanced").build())).withModelProperty((ModelProperty)new TargetModelProperty());
    }

    private void declareTry(ExtensionDeclarer extensionDeclarer) {
        ConstructDeclarer tryScope = (ConstructDeclarer)((ConstructDeclarer)extensionDeclarer.withConstruct("try").describedAs("Processes the nested list of message processors, within a transaction and with it's own error handler if required.")).withErrorModel(this.transactionError);
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)tryScope.onDefaultParameterGroup().withOptionalParameter("transactionalAction").ofType((MetadataType)MuleExtensionModelProvider.BASE_TYPE_BUILDER.stringType().enumOf(new String[]{"INDIFFERENT", "ALWAYS_BEGIN", "BEGIN_OR_JOIN"}).build())).defaultingTo((Object)"INDIFFERENT").withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).withLayout(LayoutModel.builder().tabName("Transactions").build())).describedAs("The action to take regarding transactions. By default nothing will be done.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)tryScope.onDefaultParameterGroup().withOptionalParameter("transactionType").ofType((MetadataType)MuleExtensionModelProvider.BASE_TYPE_BUILDER.stringType().enumOf(new String[]{"LOCAL", "XA"}).build())).defaultingTo((Object)"LOCAL").withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("Transaction type supported. Availability will depend on the runtime version, though LOCAL is always available.");
        tryScope.withChain().withModelProperty((ModelProperty)NoWrapperModelProperty.INSTANCE);
        tryScope.withOptionalComponent("errorHandler").withAllowedStereotypes(new StereotypeModel[]{MuleStereotypes.ERROR_HANDLER});
    }

    private void declareErrorHandler(ExtensionDeclarer extensionDeclarer) {
        ConstructDeclarer errorHandler = (ConstructDeclarer)((ConstructDeclarer)extensionDeclarer.withConstruct("errorHandler").withStereotype(MuleStereotypes.ERROR_HANDLER)).allowingTopLevelDefinition().describedAs("Allows the definition of internal selective handlers. It will route the error to the first handler that matches it. If there's no match, then a default error handler will be executed.");
        errorHandler.onDefaultParameterGroup().withRequiredParameter("name").asComponentId().ofType(MuleExtensionModelProvider.STRING_TYPE);
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)errorHandler.onDefaultParameterGroup().withOptionalParameter("ref").withAllowedStereotypes(Collections.singletonList(MuleStereotypes.ERROR_HANDLER))).ofType(MuleExtensionModelProvider.STRING_TYPE)).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("The name of the error handler to reuse.");
        NestedRouteDeclarer onErrorContinue = errorHandler.withRoute("onErrorContinue").describedAs("Error handler used to handle errors. It will commit any transaction as if the message was consumed successfully.");
        this.declareOnErrorRoute(onErrorContinue);
        NestedRouteDeclarer onErrorPropagate = errorHandler.withRoute("onErrorPropagate").describedAs("Error handler used to propagate errors. It will rollback any transaction and not consume messages.");
        this.declareOnErrorRoute(onErrorPropagate);
        errorHandler.withOptionalComponent("onError").withAllowedStereotypes(new StereotypeModel[]{MuleStereotypes.ON_ERROR}).describedAs("Error handler used to reference others.");
        ConstructDeclarer onError = (ConstructDeclarer)((ConstructDeclarer)extensionDeclarer.withConstruct("onError").withStereotype(MuleStereotypes.ON_ERROR)).describedAs("Error handler used to reference others.");
        onError.onDefaultParameterGroup().withRequiredParameter("ref").withAllowedStereotypes(Arrays.asList(MuleStereotypes.ON_ERROR)).ofType(MuleExtensionModelProvider.STRING_TYPE).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED).describedAs("The name of the error handler to reuse.");
        this.declareGlobalOnErrorRoute((ConstructDeclarer)extensionDeclarer.withConstruct("onErrorContinue").describedAs("Error handler used to handle errors. It will commit any transaction as if the message was consumed successfully."));
        this.declareGlobalOnErrorRoute((ConstructDeclarer)extensionDeclarer.withConstruct("onErrorPropagate").describedAs("Error handler used to propagate errors. It will rollback any transaction and not consume messages."));
    }

    private void declareOnErrorRoute(NestedRouteDeclarer onError) {
        onError.withChain().withModelProperty((ModelProperty)NoWrapperModelProperty.INSTANCE);
        this.declareOnErrorRouteParams((HasParametersDeclarer)onError);
    }

    private void declareGlobalOnErrorRoute(ConstructDeclarer onError) {
        ((ConstructDeclarer)onError.withStereotype(MuleStereotypes.ON_ERROR)).allowingTopLevelDefinition().withChain();
        onError.onDefaultParameterGroup().withRequiredParameter("name").asComponentId().ofType(MuleExtensionModelProvider.STRING_TYPE);
        this.declareOnErrorRouteParams((HasParametersDeclarer)onError);
    }

    private void declareOnErrorRouteParams(HasParametersDeclarer onError) {
        ((OptionalParameterDeclarer)onError.onDefaultParameterGroup().withOptionalParameter("when").ofType(MuleExtensionModelProvider.STRING_TYPE)).describedAs("The expression that will be evaluated to determine if this exception strategy should be executed. This should always be a boolean expression.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)onError.onDefaultParameterGroup().withOptionalParameter("type").ofType(ErrorConstants.ERROR_TYPE_MATCHER)).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("The full name of the error type to match against or a comma separated list of full names, to match against any of them.");
        ((OptionalParameterDeclarer)onError.onDefaultParameterGroup().withOptionalParameter("logException").ofType(MuleExtensionModelProvider.BOOLEAN_TYPE)).defaultingTo((Object)true).describedAs("Determines whether the handled exception will be logged to its standard logger in the ERROR level before being handled. Default is true.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)onError.onDefaultParameterGroup().withOptionalParameter("enableNotifications").ofType(MuleExtensionModelProvider.BOOLEAN_TYPE)).defaultingTo((Object)true).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("Determines whether ExceptionNotifications will be fired from this strategy when an exception occurs. Default is true.");
    }

    private void declareErrors(ExtensionDeclarer extensionDeclarer) {
        ErrorModel criticalError = ErrorModelBuilder.newError((ComponentIdentifier)Errors.ComponentIdentifiers.Unhandleable.CRITICAL).handleable(false).build();
        ErrorModel overloadError = ErrorModelBuilder.newError((ComponentIdentifier)Errors.ComponentIdentifiers.Unhandleable.OVERLOAD).withParent(criticalError).build();
        ErrorModel securityError = ErrorModelBuilder.newError((ComponentIdentifier)Errors.ComponentIdentifiers.Handleable.SECURITY).withParent(this.anyError).build();
        ErrorModel sourceError = ErrorModelBuilder.newError((ComponentIdentifier)Errors.ComponentIdentifiers.Handleable.SOURCE).withParent(this.anyError).build();
        ErrorModel sourceResponseError = ErrorModelBuilder.newError((ComponentIdentifier)Errors.ComponentIdentifiers.Handleable.SOURCE_RESPONSE).withParent(this.anyError).build();
        ErrorModel serverSecurityError = ErrorModelBuilder.newError((ComponentIdentifier)Errors.ComponentIdentifiers.Handleable.SERVER_SECURITY).withParent(securityError).build();
        extensionDeclarer.withErrorModel(this.anyError);
        extensionDeclarer.withErrorModel(ErrorModelBuilder.newError((ComponentIdentifier)Errors.ComponentIdentifiers.Handleable.EXPRESSION).withParent(this.anyError).build());
        extensionDeclarer.withErrorModel(ErrorModelBuilder.newError((ComponentIdentifier)Errors.ComponentIdentifiers.Handleable.TRANSFORMATION).withParent(this.anyError).build());
        extensionDeclarer.withErrorModel(ErrorModelBuilder.newError((ComponentIdentifier)Errors.ComponentIdentifiers.Handleable.CONNECTIVITY).withParent(this.anyError).build());
        extensionDeclarer.withErrorModel(ErrorModelBuilder.newError((ComponentIdentifier)Errors.ComponentIdentifiers.Handleable.RETRY_EXHAUSTED).withParent(this.anyError).build());
        extensionDeclarer.withErrorModel(ErrorModelBuilder.newError((ComponentIdentifier)Errors.ComponentIdentifiers.Handleable.REDELIVERY_EXHAUSTED).withParent(this.anyError).build());
        extensionDeclarer.withErrorModel(ErrorModelBuilder.newError((ComponentIdentifier)Errors.ComponentIdentifiers.Handleable.STREAM_MAXIMUM_SIZE_EXCEEDED).withParent(this.anyError).build());
        extensionDeclarer.withErrorModel(ErrorModelBuilder.newError((ComponentIdentifier)Errors.ComponentIdentifiers.Handleable.TIMEOUT).withParent(this.anyError).build());
        extensionDeclarer.withErrorModel(ErrorModelBuilder.newError((ComponentIdentifier)Errors.ComponentIdentifiers.Handleable.UNKNOWN).handleable(false).withParent(this.anyError).build());
        extensionDeclarer.withErrorModel(this.routingError);
        extensionDeclarer.withErrorModel(this.compositeRoutingError);
        extensionDeclarer.withErrorModel(this.validationError);
        extensionDeclarer.withErrorModel(this.duplicateMessageError);
        extensionDeclarer.withErrorModel(this.transactionError);
        extensionDeclarer.withErrorModel(securityError);
        extensionDeclarer.withErrorModel(serverSecurityError);
        extensionDeclarer.withErrorModel(ErrorModelBuilder.newError((ComponentIdentifier)Errors.ComponentIdentifiers.Handleable.CLIENT_SECURITY).withParent(securityError).build());
        extensionDeclarer.withErrorModel(ErrorModelBuilder.newError((ComponentIdentifier)Errors.ComponentIdentifiers.Handleable.NOT_PERMITTED).withParent(securityError).build());
        extensionDeclarer.withErrorModel(sourceError);
        extensionDeclarer.withErrorModel(sourceResponseError);
        extensionDeclarer.withErrorModel(ErrorModelBuilder.newError((ComponentIdentifier)Errors.ComponentIdentifiers.Handleable.SOURCE_ERROR_RESPONSE_GENERATE).handleable(false).withParent(sourceError).build());
        extensionDeclarer.withErrorModel(ErrorModelBuilder.newError((ComponentIdentifier)Errors.ComponentIdentifiers.Handleable.SOURCE_ERROR_RESPONSE_SEND).handleable(false).withParent(sourceError).build());
        extensionDeclarer.withErrorModel(ErrorModelBuilder.newError((ComponentIdentifier)Errors.ComponentIdentifiers.Handleable.SOURCE_RESPONSE_GENERATE).withParent(sourceResponseError).build());
        extensionDeclarer.withErrorModel(ErrorModelBuilder.newError((ComponentIdentifier)Errors.ComponentIdentifiers.Handleable.SOURCE_RESPONSE_SEND).handleable(false).withParent(sourceResponseError).build());
        extensionDeclarer.withErrorModel(criticalError);
        extensionDeclarer.withErrorModel(overloadError);
        extensionDeclarer.withErrorModel(ErrorModelBuilder.newError((ComponentIdentifier)Errors.ComponentIdentifiers.Unhandleable.FLOW_BACK_PRESSURE).handleable(false).withParent(overloadError).build());
        extensionDeclarer.withErrorModel(ErrorModelBuilder.newError((ComponentIdentifier)Errors.ComponentIdentifiers.Unhandleable.FATAL).handleable(false).withParent(criticalError).build());
    }

    private void declareFunctions(ExtensionDeclarer extensionDeclarer) {
        FunctionDeclarer functionDeclarer = extensionDeclarer.withFunction("p");
        functionDeclarer.onDefaultParameterGroup().withRequiredParameter("name").ofType(MuleExtensionModelProvider.STRING_TYPE);
        functionDeclarer.withOutput().describedAs("Returns the value of a property").ofType(MuleExtensionModelProvider.STRING_TYPE);
        functionDeclarer = extensionDeclarer.withFunction("lookup");
        functionDeclarer.onDefaultParameterGroup().withRequiredParameter("flowName").ofType(MuleExtensionModelProvider.STRING_TYPE);
        functionDeclarer.onDefaultParameterGroup().withRequiredParameter("payload").ofType(MuleExtensionModelProvider.ANY_TYPE);
        functionDeclarer.onDefaultParameterGroup().withOptionalParameter("timeoutMillis").ofType(MuleExtensionModelProvider.INTEGER_TYPE);
        functionDeclarer.withOutput().describedAs("Executes the desired flow with the specified payload and returns its result").ofType(MuleExtensionModelProvider.ANY_TYPE);
        functionDeclarer = extensionDeclarer.withFunction("causedBy");
        functionDeclarer.onDefaultParameterGroup().withRequiredParameter("error").ofType(ErrorConstants.ERROR);
        functionDeclarer.onDefaultParameterGroup().withRequiredParameter("type").ofType(MuleExtensionModelProvider.STRING_TYPE);
        functionDeclarer.withOutput().describedAs("Determines whether an error matches a certain error type").ofType(MuleExtensionModelProvider.BOOLEAN_TYPE);
    }

    private void declareConfiguration(ExtensionDeclarer extensionDeclarer) {
        ConstructDeclarer configuration = (ConstructDeclarer)((ConstructDeclarer)((ConstructDeclarer)extensionDeclarer.withConstruct("configuration").allowingTopLevelDefinition().withStereotype(MuleStereotypes.APP_CONFIG)).withModelProperty((ModelProperty)new SingletonModelProperty(false))).describedAs("Specifies defaults and general settings for the Mule instance.");
        InfrastructureParameterBuilder.addReconnectionStrategyParameter((ParameterizedDeclaration)((ParameterizedDeclaration)configuration.getDeclaration()));
        this.declareExpressionLanguage(configuration.withOptionalComponent("expression-language"));
        this.declareConfigurationElementsPlaceholder(configuration);
        ParameterGroupDeclarer params = configuration.onDefaultParameterGroup();
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)params.withOptionalParameter("defaultResponseTimeout").ofType(MuleExtensionModelProvider.STRING_TYPE)).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).defaultingTo((Object)"10000").describedAs("The default period (ms) to wait for a synchronous response.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)params.withOptionalParameter("defaultTransactionTimeout").ofType(MuleExtensionModelProvider.STRING_TYPE)).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).defaultingTo((Object)"30000").describedAs("The default timeout (ms) for transactions. This can also be configured on transactions, in which case the transaction configuration is used instead of this default.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)params.withOptionalParameter("defaultErrorHandler-ref").ofType(MuleExtensionModelProvider.STRING_TYPE)).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).withAllowedStereotypes(Collections.singletonList(MuleStereotypes.ERROR_HANDLER))).describedAs("The default error handler for every flow. This must be a reference to a global error handler.")).withDsl(ParameterDslConfiguration.builder().allowsReferences(true).allowsInlineDefinition(false).allowTopLevelDefinition(false).build());
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)params.withOptionalParameter("inheritIterableRepeatability").ofType(MuleExtensionModelProvider.BOOLEAN_TYPE)).defaultingTo((Object)false).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("Whether streamed iterable objects should follow the repeatability strategy of the iterable or use the default one.")).withModelProperty((ModelProperty)new SinceMuleVersionModelProperty("4.3.0"));
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)params.withOptionalParameter("shutdownTimeout").ofType(MuleExtensionModelProvider.INTEGER_TYPE)).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).defaultingTo((Object)"5000").describedAs("The time in milliseconds to wait for any in-progress work to finish running before Mule shuts down. After this threshold has been reached, Mule starts stopping schedulers and interrupting threads, and messages can be lost. If you have a very large number of services in the same Mule instance, if you have components that take more than a couple seconds to process, or if you are using large payloads and/or slower transports, you should increase this value to allow more time for graceful shutdown. The value you specify is applied to services and separately to dispatchers, so the default value of 5000 milliseconds specifies that Mule has ten seconds to process and dispatch messages gracefully after shutdown is initiated.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)params.withOptionalParameter("maxQueueTransactionFilesSize").ofType(MuleExtensionModelProvider.INTEGER_TYPE)).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).defaultingTo((Object)"500").describedAs("Sets the approximate maximum space in megabytes allowed for the transaction log files for transactional persistent queues. Take into account that this number applies both to the set of transaction log files for XA and for local transactions. If both types of transactions are used then the approximate maximum space used, will be twice the configured value.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)params.withOptionalParameter("defaultObjectSerializer-ref").ofType(MuleExtensionModelProvider.STRING_TYPE)).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).withAllowedStereotypes(Collections.singletonList(MuleStereotypes.SERIALIZER))).describedAs("An optional reference to an ObjectSerializer to be used as the application's default")).withDsl(ParameterDslConfiguration.builder().allowsReferences(true).allowsInlineDefinition(false).allowTopLevelDefinition(false).build());
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)params.withOptionalParameter("dynamicConfigExpiration").describedAs("Configuration about how should the runtime handle the expiration of dynamic configurations")).ofType(new DynamicConfigExpirationTypeBuilder().buildDynamicConfigExpirationType())).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).withDsl(ParameterDslConfiguration.builder().allowsReferences(false).allowsInlineDefinition(true).allowTopLevelDefinition(false).build());
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)params.withOptionalParameter("correlationIdGeneratorExpression").ofType(MuleExtensionModelProvider.STRING_TYPE)).withExpressionSupport(ExpressionSupport.REQUIRED)).describedAs("The default correlation id generation expression for every source. This must be DataWeave expression.");
    }

    private void declareConfigurationElementsPlaceholder(ConstructDeclarer configuration) {
        configuration.withOptionalComponent("abstractConfigurationElement").withAllowedStereotypes(new StereotypeModel[]{org.mule.sdk.api.stereotype.MuleStereotypes.CONFIGURATION_ELEMENT}).describedAs("A placeholder for configuration elements.");
    }

    private void declareExpressionLanguage(NestedComponentDeclarer expressionLanguageDeclarer) {
        expressionLanguageDeclarer.describedAs("Configuration of Mule Expression Language").withDeprecation((DeprecationModel)new ImmutableDeprecationModel("Only meant to be used for backwards compatibility.", "4.0", "5.0"));
        ((OptionalParameterDeclarer)expressionLanguageDeclarer.onDefaultParameterGroup().withOptionalParameter("autoResolveVariables").ofType(MuleExtensionModelProvider.BOOLEAN_TYPE)).defaultingTo((Object)true).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
        ParameterGroupDeclarer importParameters = expressionLanguageDeclarer.withOptionalComponent("import").onDefaultParameterGroup();
        ((OptionalParameterDeclarer)importParameters.withOptionalParameter("name").ofType(MuleExtensionModelProvider.STRING_TYPE)).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
        importParameters.withRequiredParameter("class").ofType(MuleExtensionModelProvider.STRING_TYPE).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
        ParameterGroupDeclarer aliasParameters = expressionLanguageDeclarer.withOptionalComponent("alias").onDefaultParameterGroup();
        aliasParameters.withRequiredParameter("name").ofType(MuleExtensionModelProvider.STRING_TYPE).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
        aliasParameters.withRequiredParameter("expression").ofType(MuleExtensionModelProvider.STRING_TYPE).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
        ParameterGroupDeclarer globalFunctionsParameters = expressionLanguageDeclarer.withOptionalComponent("global-functions").onDefaultParameterGroup();
        ((OptionalParameterDeclarer)globalFunctionsParameters.withOptionalParameter("file").ofType(MuleExtensionModelProvider.STRING_TYPE)).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
    }

    private void declareConfigurationProperties(ExtensionDeclarer extensionDeclarer) {
        ConstructDeclarer configuration = (ConstructDeclarer)((ConstructDeclarer)extensionDeclarer.withConstruct("configurationProperties").allowingTopLevelDefinition().withStereotype(MuleStereotypes.APP_CONFIG)).describedAs("Configuration properties are key/value pairs that can be stored in configuration files or set as system environment variables. \nEach property%2Cs value can be referenced inside the attributes of a mule configuration file by wrapping the property%2Cs key name in the syntax: \n${key_name}. \n At runtime, each property placeholder expression is substituted with the property's value. \nThis allows you to externalize configuration of properties outside the Mule application's deployable archive, and to allow others to change these properties based on the environment the application is being deployed to. Note that a system environment variable with a matching key name will override the same key%2Cs value from a properties file. Each property has a key and a value. \nThe key can be referenced from the mule configuration files using the following semantics: \n${key_name}. This allows to externalize configuration and change it based\non the environment the application is being deployed to.");
        ParameterGroupDeclarer defaultParameterGroup = configuration.onDefaultParameterGroup();
        defaultParameterGroup.withRequiredParameter("file").ofType(MuleExtensionModelProvider.STRING_TYPE).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED).withDisplayModel(DisplayModel.builder().path(new PathModel(PathModel.Type.FILE, false, PathModel.Location.EMBEDDED, new String[]{"yaml", "properties"})).build()).describedAs(" The location of the file with the configuration properties to use. It may be a location in the classpath or an absolute location. \nThe file location value may also contains references to properties that will only be resolved based on system properties or properties set at deployment time.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)defaultParameterGroup.withOptionalParameter("encoding").ofType(MuleExtensionModelProvider.STRING_TYPE)).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("The encoding of the file with the configuration properties to use.");
    }

    private void declareNotifications(ExtensionDeclarer extensionDeclarer) {
        ConstructDeclarer notificationsConstructDeclarer = (ConstructDeclarer)((ConstructDeclarer)((ConstructDeclarer)extensionDeclarer.withConstruct("notifications").allowingTopLevelDefinition().withStereotype(StereotypeModelBuilder.newStereotype((String)"NOTIFICATIONS", (String)"MULE").withParent(MuleStereotypes.APP_CONFIG).build())).describedAs("Registers listeners for notifications and associates interfaces with particular events.")).withDeprecation((DeprecationModel)new ImmutableDeprecationModel("Only meant to be used for backwards compatibility.", "4.0", "5.0"));
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)notificationsConstructDeclarer.onDefaultParameterGroup().withOptionalParameter("dynamic").ofType(MuleExtensionModelProvider.BOOLEAN_TYPE)).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).defaultingTo((Object)false).describedAs("If the notification manager is dynamic, listeners can be registered dynamically at runtime via the MuleContext, and the configured notification can be changed. Otherwise, some parts of Mule will cache notification configuration for efficiency and will not generate events for newly enabled notifications or listeners. The default value is false.");
        this.declareEnableNotification(notificationsConstructDeclarer.withOptionalComponent("notification"));
        this.declareDisableNotification(notificationsConstructDeclarer.withOptionalComponent("disable-notification"));
        this.declareNotificationListener(notificationsConstructDeclarer.withOptionalComponent("notification-listener"));
    }

    private void declareEnableNotification(NestedComponentDeclarer enableNotificationDeclarer) {
        enableNotificationDeclarer.describedAs("Registers listeners for notifications and associates interfaces with particular events");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)enableNotificationDeclarer.onDefaultParameterGroup().withOptionalParameter("event-class").ofType(MuleExtensionModelProvider.STRING_TYPE)).withDisplayModel(DisplayModel.builder().classValue(NOTIFICATION_CLASS_VALUE_MODEL).displayName("Event class").build())).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("The class associated with a notification event that will be delivered to the interface.\nThis can be used instead of the 'event' attribute to specify a custom class.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)enableNotificationDeclarer.onDefaultParameterGroup().withOptionalParameter("event").ofType(MuleExtensionModelProvider.STRING_TYPE)).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("The notification event to deliver.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)enableNotificationDeclarer.onDefaultParameterGroup().withOptionalParameter("interface-class").ofType(MuleExtensionModelProvider.STRING_TYPE)).withDisplayModel(DisplayModel.builder().classValue(NOTIFICATION_CLASS_VALUE_MODEL).displayName("Interface class").build())).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("The interface (class name) that will receive the notification event.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)enableNotificationDeclarer.onDefaultParameterGroup().withOptionalParameter("interface").ofType(MuleExtensionModelProvider.STRING_TYPE)).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("The interface that will receive the notification event.");
    }

    private void declareDisableNotification(NestedComponentDeclarer disableNotificationDeclarer) {
        disableNotificationDeclarer.describedAs("Blocks the association of an event with a particular interface. This filters events after the association with a particular interface (and so takes precedence).");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)disableNotificationDeclarer.onDefaultParameterGroup().withOptionalParameter("event-class").ofType(MuleExtensionModelProvider.STRING_TYPE)).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).withDisplayModel(DisplayModel.builder().classValue(NOTIFICATION_CLASS_VALUE_MODEL).displayName("Event class").build())).describedAs("The class associated with an event that will no longer be delivered to any interface. This can be used instead of the 'event' attribute to specify a custom class.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)disableNotificationDeclarer.onDefaultParameterGroup().withOptionalParameter("event").ofType(MuleExtensionModelProvider.STRING_TYPE)).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("The event you no longer want to deliver.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)disableNotificationDeclarer.onDefaultParameterGroup().withOptionalParameter("interface-class").ofType(MuleExtensionModelProvider.STRING_TYPE)).withDisplayModel(DisplayModel.builder().classValue(NOTIFICATION_CLASS_VALUE_MODEL).displayName("Interface class").build())).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("The interface (class name) that will no longer receive the event.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)disableNotificationDeclarer.onDefaultParameterGroup().withOptionalParameter("interface").ofType(MuleExtensionModelProvider.STRING_TYPE)).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("The interface that will no longer receive the event.");
    }

    private void declareNotificationListener(NestedComponentDeclarer notificationListenerDeclarer) {
        notificationListenerDeclarer.describedAs("Registers a bean as a listener with the notification system. Events are dispatched by reflection - the listener will receive all events associated with any interfaces it implements. The relationship between interfaces and events is configured by the notification and disable-notification elements.");
        notificationListenerDeclarer.onDefaultParameterGroup().withRequiredParameter("ref").ofType(MuleExtensionModelProvider.STRING_TYPE).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED).describedAs("The bean that will receive notifications.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)notificationListenerDeclarer.onDefaultParameterGroup().withOptionalParameter("subscription").ofType(MuleExtensionModelProvider.STRING_TYPE)).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).defaultingTo((Object)"*").describedAs("An optional string that is compared with the event resource identifier. Only events with matching identifiers will be sent. If no value is given, all events are sent.");
    }

    private void declareGlobalProperties(ExtensionDeclarer extensionDeclarer) {
        ConstructDeclarer globalPropDeclarer = (ConstructDeclarer)((ConstructDeclarer)extensionDeclarer.withConstruct("globalProperty").allowingTopLevelDefinition().withStereotype(MuleStereotypes.APP_CONFIG)).describedAs("A global property is a named string. It can be inserted in most attribute values using standard (${key}) property placeholders.");
        globalPropDeclarer.onDefaultParameterGroup().withRequiredParameter("name").ofType(MuleExtensionModelProvider.STRING_TYPE).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED).describedAs("The name of the property. This is used inside property placeholders.");
        globalPropDeclarer.onDefaultParameterGroup().withRequiredParameter("value").ofType(MuleExtensionModelProvider.STRING_TYPE).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED).describedAs("The value of the property. This replaces each occurence of a property placeholder.");
    }

    private void declareSecurityManager(ExtensionDeclarer extensionDeclarer, ClassTypeLoader typeLoader) {
        ConstructDeclarer securityManagerDeclarer = (ConstructDeclarer)((ConstructDeclarer)extensionDeclarer.withConstruct("securityManager").allowingTopLevelDefinition().describedAs("The default security manager provides basic support for security functions. Other modules (PGP, Spring) provide more advanced functionality.")).withDeprecation((DeprecationModel)new ImmutableDeprecationModel("Mule Runtime no longer uses this.", "4.4", "5.0"));
        ParameterGroupDeclarer customSecurityProviderParameterGroup = securityManagerDeclarer.withOptionalComponent("customSecurityProvider").describedAs("A custom implementation of SecurityProvider.").onDefaultParameterGroup();
        customSecurityProviderParameterGroup.withRequiredParameter("name").describedAs("A security provider is a source of specific security-related functionality.").withExpressionSupport(ExpressionSupport.NOT_SUPPORTED).ofType(MuleExtensionModelProvider.STRING_TYPE);
        customSecurityProviderParameterGroup.withRequiredParameter("provider-ref").describedAs("The name of the security provider to use.").withExpressionSupport(ExpressionSupport.NOT_SUPPORTED).ofType(MuleExtensionModelProvider.STRING_TYPE);
        ParameterGroupDeclarer customEncryptionStrategyParameterGroup = securityManagerDeclarer.withOptionalComponent("customEncryptionStrategy").describedAs("A custom implementation of EncryptionStrategy.").onDefaultParameterGroup();
        customEncryptionStrategyParameterGroup.withRequiredParameter("name").describedAs("An encryption strategy provides support for a specific encryption algorithm.").withExpressionSupport(ExpressionSupport.NOT_SUPPORTED).ofType(MuleExtensionModelProvider.STRING_TYPE);
        customEncryptionStrategyParameterGroup.withRequiredParameter("strategy-ref").describedAs("A reference to the encryption strategy (which may be a Spring bean that implements the EncryptionStrategy interface).").withExpressionSupport(ExpressionSupport.NOT_SUPPORTED).ofType(MuleExtensionModelProvider.STRING_TYPE);
        ParameterGroupDeclarer secretKeyEncryptionStrategyParameterGroup = securityManagerDeclarer.withOptionalComponent("secretKeyEncryptionStrategy").describedAs("Provides secret key-based encryption using JCE.").onDefaultParameterGroup();
        secretKeyEncryptionStrategyParameterGroup.withRequiredParameter("name").describedAs("An encryption strategy provides support for a specific encryption algorithm.").withExpressionSupport(ExpressionSupport.NOT_SUPPORTED).ofType(MuleExtensionModelProvider.STRING_TYPE);
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)secretKeyEncryptionStrategyParameterGroup.withOptionalParameter("key").describedAs("The key to use. This and the 'keyFactory-ref' attribute are mutually exclusive.")).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).ofType(MuleExtensionModelProvider.STRING_TYPE);
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)secretKeyEncryptionStrategyParameterGroup.withOptionalParameter("keyFactory-ref").describedAs("The name of the key factory to use. This should implement the ObjectFactory interface and return a byte array. This and the 'key' attribute are mutually exclusive.")).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).ofType(MuleExtensionModelProvider.STRING_TYPE);
        secretKeyEncryptionStrategyParameterGroup.withExclusiveOptionals((Set)ImmutableSet.of((Object)"key", (Object)"keyFactory-ref"), true);
        ParameterGroupDeclarer passwordEncryptionStrategyParameterGroup = securityManagerDeclarer.withOptionalComponent("passwordEncryptionStrategy").describedAs("Provides password-based encryption using JCE. Users must specify a password andoptionally a salt and iteration count as well. The default algorithm isPBEWithMD5AndDES, but users can specify any valid algorithm supported by JCE.").onDefaultParameterGroup();
        passwordEncryptionStrategyParameterGroup.withRequiredParameter("name").describedAs("An encryption strategy provides support for a specific encryption algorithm.").withExpressionSupport(ExpressionSupport.NOT_SUPPORTED).ofType(MuleExtensionModelProvider.STRING_TYPE);
        passwordEncryptionStrategyParameterGroup.withRequiredParameter("password").describedAs("The password to use.").withExpressionSupport(ExpressionSupport.NOT_SUPPORTED).ofType(MuleExtensionModelProvider.STRING_TYPE);
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)passwordEncryptionStrategyParameterGroup.withOptionalParameter("salt").describedAs("The salt to use (this helps prevent dictionary attacks).")).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).ofType(MuleExtensionModelProvider.STRING_TYPE);
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)passwordEncryptionStrategyParameterGroup.withOptionalParameter("iterationCount").describedAs("The number of iterations to use.")).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).ofType(MuleExtensionModelProvider.INTEGER_TYPE);
    }

    private void declareSecurityFilter(ExtensionDeclarer extensionDeclarer) {
        ConstructDeclarer encryptionSecurityFilterDeclarer = (ConstructDeclarer)((ConstructDeclarer)extensionDeclarer.withConstruct("encryptionSecurityFilter").describedAs("A filter that provides password-based encyption.")).withDeprecation((DeprecationModel)new ImmutableDeprecationModel("Mule Runtime no longer uses this.", "4.4", "5.0"));
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)encryptionSecurityFilterDeclarer.onDefaultParameterGroup().withOptionalParameter("strategy-ref").ofType(MuleExtensionModelProvider.STRING_TYPE)).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("The name of the encryption strategy to use. This should be configured using the 'password-encryption-strategy' element, inside a 'security-manager' element at the top level.");
    }
}

