/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.util.ComponentAstPredicatesFactory;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResultItem;
import org.mule.runtime.config.internal.validation.AbstractErrorTypesValidation;

public class RaiseErrorReferenceDoNotUseExtensionNamespaces
extends AbstractErrorTypesValidation {
    public RaiseErrorReferenceDoNotUseExtensionNamespaces(Optional<FeatureFlaggingService> featureFlaggingService) {
        super(featureFlaggingService);
    }

    public String getName() {
        return "Error Type references don't use extension namespaces";
    }

    public String getDescription() {
        return "Referenced error types do not use extension namespaces.";
    }

    public Predicate<List<ComponentAst>> applicable() {
        return ComponentAstPredicatesFactory.currentElemement(ComponentAstPredicatesFactory.equalsIdentifier((ComponentIdentifier)RAISE_ERROR_IDENTIFIER).and(component -> !StringUtils.isEmpty((CharSequence)RaiseErrorReferenceDoNotUseExtensionNamespaces.getErrorTypeParam(component).getResolvedRawValue())));
    }

    public Optional<ValidationResultItem> validate(ComponentAst component, ArtifactAst artifact) {
        ComponentIdentifier errorTypeId;
        String namespace;
        ComponentParameterAst errorTypeParam = RaiseErrorReferenceDoNotUseExtensionNamespaces.getErrorTypeParam(component);
        String errorTypeString = errorTypeParam.getResolvedRawValue();
        Set<String> alreadyUsedErrorNamespaces = RaiseErrorReferenceDoNotUseExtensionNamespaces.getAlreadyUsedErrorNamespaces(artifact);
        if (alreadyUsedErrorNamespaces.contains(namespace = (errorTypeId = RaiseErrorReferenceDoNotUseExtensionNamespaces.parseErrorType(errorTypeString)).getNamespace()) && !RaiseErrorReferenceDoNotUseExtensionNamespaces.isAllowedBorrowedNamespace(namespace)) {
            return Optional.of(ValidationResultItem.create((ComponentAst)component, (ComponentParameterAst)errorTypeParam, (Validation)this, (String)String.format("Cannot use error type '%s': namespace already exists.", errorTypeString)));
        }
        return Optional.empty();
    }

    private static ComponentParameterAst getErrorTypeParam(ComponentAst component) {
        return component.getParameter("General", "type");
    }
}

