/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.util.ComponentAstPredicatesFactory;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResultItem;
import org.mule.runtime.config.internal.dsl.DslUtils;

public class OperationErrorHandlersDoNotReferGlobalErrorHandlers
implements Validation {
    public String getName() {
        return "Operation error handlers don't refer global error handlers";
    }

    public String getDescription() {
        return "Error handlers within a reusable operation can't have references to global error handlers, neither use the default one, since it's also global.";
    }

    public Validation.Level getLevel() {
        return Validation.Level.ERROR;
    }

    public Predicate<List<ComponentAst>> applicable() {
        return ComponentAstPredicatesFactory.currentElemement((Predicate)ComponentAstPredicatesFactory.equalsIdentifier((ComponentIdentifier)DslUtils.OPERATION_BODY_IDENTIFIER));
    }

    public List<ValidationResultItem> validateMany(ComponentAst component, ArtifactAst artifact) {
        return component.recursiveStream().filter(DslUtils::isTryScope).flatMap(this::validateTryScope).collect(Collectors.toList());
    }

    private Stream<ValidationResultItem> validateTryScope(ComponentAst tryAst) {
        Optional errorHandlerOpt = tryAst.directChildrenStreamByIdentifier("mule", "error-handler").findFirst();
        if (!errorHandlerOpt.isPresent()) {
            return Stream.of(ValidationResultItem.create((ComponentAst)tryAst, (Validation)this, (String)"Try scopes within a reusable operation can't use the default error handler because it's global. You have to specify an error handler."));
        }
        ComponentAst errorHandlerAst = (ComponentAst)errorHandlerOpt.get();
        ComponentParameterAst referenceParameter = errorHandlerAst.getParameter("General", "ref");
        if (referenceParameter.getValue().getValue().isPresent()) {
            return Stream.of(ValidationResultItem.create((ComponentAst)errorHandlerAst, (ComponentParameterAst)referenceParameter, (Validation)this, (String)"Error handlers within a reusable operation can't have references to global ones."));
        }
        if (errorHandlerAst.directChildren().isEmpty()) {
            return Stream.of(ValidationResultItem.create((ComponentAst)errorHandlerAst, (Validation)this, (String)"The error handler section of a try within a reusable operation must have at least one error handler"));
        }
        return Stream.empty();
    }
}

