/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.util.ComponentAstPredicatesFactory;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResultItem;
import org.mule.runtime.config.internal.validation.AbstractErrorTypesValidation;

public class ErrorHandlerOnErrorTypeExists
extends AbstractErrorTypesValidation {
    public ErrorHandlerOnErrorTypeExists(Optional<FeatureFlaggingService> featureFlaggingService) {
        super(featureFlaggingService);
    }

    public String getName() {
        return "Error Type references exist";
    }

    public String getDescription() {
        return "Referenced error types do exist in the context of the artifact.";
    }

    public Predicate<List<ComponentAst>> applicable() {
        return ComponentAstPredicatesFactory.currentElemement(comp -> (comp.getIdentifier().equals(ON_ERROR_IDENTIFIER) || comp.getIdentifier().equals(ON_ERROR_PROPAGATE_IDENTIFIER) || comp.getIdentifier().equals(ON_ERROR_CONTINUE_IDENTIFIER)) && comp.getParameter("General", "type") != null && comp.getParameter("General", "type").getResolvedRawValue() != null);
    }

    public Optional<ValidationResultItem> validate(ComponentAst onErrorModel, ArtifactAst artifact) {
        ComponentParameterAst errorTypeParam = onErrorModel.getParameter("General", "type");
        for (String type : errorTypeParam.getResolvedRawValue().split(",")) {
            ComponentIdentifier parsedErrorType = ErrorHandlerOnErrorTypeExists.parseErrorType(type.trim());
            if ("*".equals(parsedErrorType.getNamespace()) || "*".equals(parsedErrorType.getName())) {
                return Optional.empty();
            }
            Optional errorType = artifact.getErrorTypeRepository().lookupErrorType(parsedErrorType);
            if (errorType.isPresent()) continue;
            return Optional.of(ValidationResultItem.create((ComponentAst)onErrorModel, (ComponentParameterAst)errorTypeParam, (Validation)this, (String)String.format("Could not find error '%s'", type.trim())));
        }
        return Optional.empty();
    }
}

