/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.mule.runtime.api.config.Feature;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.config.MuleRuntimeFeature;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.el.validation.Severity;
import org.mule.runtime.ast.api.validation.ArtifactValidation;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationsProvider;
import org.mule.runtime.config.internal.validation.AllComponentsBelongToSomeExtensionModel;
import org.mule.runtime.config.internal.validation.ConfigReferenceParametersStereotypesValidations;
import org.mule.runtime.config.internal.validation.DynamicConfigWithStatefulOperationConfigurationOverride;
import org.mule.runtime.config.internal.validation.ErrorHandlerOnErrorHasTypeOrWhen;
import org.mule.runtime.config.internal.validation.ErrorHandlerOnErrorTypeExists;
import org.mule.runtime.config.internal.validation.ErrorHandlerRefOrOnErrorExclusiveness;
import org.mule.runtime.config.internal.validation.ErrorMappingSourceTypeReferencesExist;
import org.mule.runtime.config.internal.validation.ErrorMappingTargetTypeReferencesDoNotUseExtensionNamespace;
import org.mule.runtime.config.internal.validation.ErrorMappingTargetTypeReferencesExist;
import org.mule.runtime.config.internal.validation.ExpressionParametersSyntacticallyValid;
import org.mule.runtime.config.internal.validation.ExpressionsInRequiredExpressionsParams;
import org.mule.runtime.config.internal.validation.FirstSuccessfulRoutes;
import org.mule.runtime.config.internal.validation.FlowRefPointsToExistingFlow;
import org.mule.runtime.config.internal.validation.ImportValidTarget;
import org.mule.runtime.config.internal.validation.InsecureTLSValidation;
import org.mule.runtime.config.internal.validation.NameHasValidCharacters;
import org.mule.runtime.config.internal.validation.NameIsNotRepeated;
import org.mule.runtime.config.internal.validation.NamedTopLevelElementsHaveName;
import org.mule.runtime.config.internal.validation.NoExpressionsInNoExpressionsSupportedParams;
import org.mule.runtime.config.internal.validation.OperationDoesNotHaveCoreRaiseError;
import org.mule.runtime.config.internal.validation.OperationDoesNotHaveFlowRef;
import org.mule.runtime.config.internal.validation.OperationErrorHandlersDoNotReferGlobalErrorHandlers;
import org.mule.runtime.config.internal.validation.OperationParameterDefaultValueDoesntSupportExpressions;
import org.mule.runtime.config.internal.validation.OperationRaiseErrorDoesntSpecifyNamespace;
import org.mule.runtime.config.internal.validation.ParameterGroupExclusiveness;
import org.mule.runtime.config.internal.validation.ParseTemplateResourceExist;
import org.mule.runtime.config.internal.validation.PollingSourceHasSchedulingStrategy;
import org.mule.runtime.config.internal.validation.RaiseErrorReferenceDoNotUseExtensionNamespaces;
import org.mule.runtime.config.internal.validation.RaiseErrorTypeReferencesExist;
import org.mule.runtime.config.internal.validation.RaiseErrorTypeReferencesPresent;
import org.mule.runtime.config.internal.validation.ReferenceParametersStereotypesValidations;
import org.mule.runtime.config.internal.validation.RequiredParametersPresent;
import org.mule.runtime.config.internal.validation.RoundRobinRoutes;
import org.mule.runtime.config.internal.validation.ScatterGatherRoutes;
import org.mule.runtime.config.internal.validation.SingletonsAreNotRepeated;
import org.mule.runtime.config.internal.validation.SingletonsPerFileAreNotRepeated;
import org.mule.runtime.config.internal.validation.SourceErrorMappingAnyLast;
import org.mule.runtime.config.internal.validation.SourceErrorMappingAnyNotRepeated;
import org.mule.runtime.config.internal.validation.SourceErrorMappingTypeNotRepeated;
import org.mule.runtime.config.internal.validation.SourcePositiveMaxItemsPerPoll;

public class CoreValidationsProvider
implements ValidationsProvider {
    private ClassLoader artifactRegionClassLoader;
    @Inject
    private final Optional<FeatureFlaggingService> featureFlaggingService = Optional.empty();
    @Inject
    private ExpressionLanguage expressionLanguage;

    public List<Validation> get() {
        ArrayList<Validation> validations = new ArrayList<Validation>(Arrays.asList(new AllComponentsBelongToSomeExtensionModel(), new SingletonsAreNotRepeated(), new SingletonsPerFileAreNotRepeated(), new NamedTopLevelElementsHaveName(), new NameHasValidCharacters(), new NameIsNotRepeated(), new FlowRefPointsToExistingFlow(), new SourceErrorMappingAnyNotRepeated(), new SourceErrorMappingAnyLast(), new SourceErrorMappingTypeNotRepeated(), new ErrorHandlerRefOrOnErrorExclusiveness(), new ErrorHandlerOnErrorHasTypeOrWhen(), new RaiseErrorTypeReferencesPresent(this.featureFlaggingService), new RaiseErrorReferenceDoNotUseExtensionNamespaces(this.featureFlaggingService), new RaiseErrorTypeReferencesExist(this.featureFlaggingService), new ErrorMappingTargetTypeReferencesExist(this.featureFlaggingService), new ErrorMappingSourceTypeReferencesExist(this.featureFlaggingService), new ErrorMappingTargetTypeReferencesDoNotUseExtensionNamespace(this.featureFlaggingService), new ErrorHandlerOnErrorTypeExists(this.featureFlaggingService), new RequiredParametersPresent(), new ParameterGroupExclusiveness(), new OperationErrorHandlersDoNotReferGlobalErrorHandlers(), new ExpressionsInRequiredExpressionsParams(this.featureFlaggingService), new OperationParameterDefaultValueDoesntSupportExpressions(), new NoExpressionsInNoExpressionsSupportedParams(), new DynamicConfigWithStatefulOperationConfigurationOverride(), new PollingSourceHasSchedulingStrategy(), new RoundRobinRoutes(), new FirstSuccessfulRoutes(), new ScatterGatherRoutes(), new ParseTemplateResourceExist(this.artifactRegionClassLoader), new SourcePositiveMaxItemsPerPoll(), new OperationRaiseErrorDoesntSpecifyNamespace(), new OperationDoesNotHaveCoreRaiseError(), new OperationDoesNotHaveFlowRef(), new InsecureTLSValidation()));
        if (this.expressionLanguage != null) {
            validations.add(new ExpressionParametersSyntacticallyValid(this.expressionLanguage, () -> CoreValidationsProvider.getExpressionSyntacticValidationErrorLevel(this.featureFlaggingService), Severity.ERROR));
            validations.add(new ExpressionParametersSyntacticallyValid(this.expressionLanguage, () -> Validation.Level.WARN, Severity.WARNING));
        }
        return validations;
    }

    public static Validation.Level getExpressionSyntacticValidationErrorLevel(Optional<FeatureFlaggingService> featureFlaggingService) {
        boolean validateExpressions = true;
        String validateExpressionsPropValue = System.getProperty("mule.validate.expressions");
        if (validateExpressionsPropValue != null) {
            validateExpressions = Boolean.valueOf(validateExpressionsPropValue);
        }
        return validateExpressions && featureFlaggingService.map(ffs -> ffs.isEnabled((Feature)MuleRuntimeFeature.ENFORCE_EXPRESSION_VALIDATION)).orElse(true) != false ? Validation.Level.ERROR : Validation.Level.WARN;
    }

    public List<ArtifactValidation> getArtifactValidations() {
        return Arrays.asList(new ImportValidTarget(), new ConfigReferenceParametersStereotypesValidations(this.featureFlaggingService), new ReferenceParametersStereotypesValidations());
    }

    public void setArtifactRegionClassLoader(ClassLoader artifactRegionClassLoader) {
        this.artifactRegionClassLoader = artifactRegionClassLoader;
    }
}

