/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.util.ComponentAstPredicatesFactory;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResultItem;

public class OperationDoesNotHaveFlowRef
implements Validation {
    private static final String FLOW_REF_ELEMENT = "flow-ref";
    private static final ComponentIdentifier FLOW_REF_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("flow-ref").build();
    private static final ComponentIdentifier OPERATION_IDENTIFIER = ComponentIdentifier.builder().namespace("operation").name("def").build();

    public String getName() {
        return "Operation doesn't have flow-ref";
    }

    public String getDescription() {
        return "Operations cannot have a flow-ref component within";
    }

    public Validation.Level getLevel() {
        return Validation.Level.ERROR;
    }

    public Predicate<List<ComponentAst>> applicable() {
        return ComponentAstPredicatesFactory.topLevelElement().and(ComponentAstPredicatesFactory.currentElemement(component -> component.getIdentifier().equals(OPERATION_IDENTIFIER)));
    }

    public Optional<ValidationResultItem> validate(ComponentAst component, ArtifactAst artifact) {
        if (component.recursiveStream().anyMatch(c -> c.getIdentifier().equals(FLOW_REF_IDENTIFIER))) {
            return Optional.of(ValidationResultItem.create((ComponentAst)component, (Validation)this, (String)String.format("Flow references (%s) are not allowed inside a Mule Operation Definition (%s)", FLOW_REF_ELEMENT, OPERATION_IDENTIFIER)));
        }
        return Optional.empty();
    }
}

