/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.SourceCallbackModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.util.ComponentAstPredicatesFactory;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResultItem;
import org.mule.runtime.config.internal.validation.IgnoreOnLazyInit;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;

@IgnoreOnLazyInit(forceDslDeclarationValidation=true)
public class RequiredParametersPresent
implements Validation {
    public String getName() {
        return "Required parameters are present.";
    }

    public String getDescription() {
        return "Required parameters are present.";
    }

    public Validation.Level getLevel() {
        return Validation.Level.ERROR;
    }

    public Predicate<List<ComponentAst>> applicable() {
        return ComponentAstPredicatesFactory.currentElemement(comp -> comp.getModel(ParameterizedModel.class).map(pmzd -> pmzd.getParameterGroupModels().stream().flatMap(pmg -> pmg.getParameterModels().stream()).anyMatch(this::isDoValidation)).orElse(false));
    }

    public List<ValidationResultItem> validateMany(ComponentAst component, ArtifactAst artifact) {
        return this.requiredParamsStream(component).map(param -> {
            if (param.getSecond() == null || !((ComponentParameterAst)param.getSecond()).getValueOrResolutionError().getValue().isPresent()) {
                return Optional.of(ValidationResultItem.create((ComponentAst)component, (ComponentParameterAst)((ComponentParameterAst)param.getSecond()), (Validation)this, (String)String.format("Element <%s> is missing required parameter '%s'.", component.getIdentifier().toString(), ((ParameterModel)param.getFirst()).getName())));
            }
            if (((ComponentParameterAst)param.getSecond()).getValueOrResolutionError().isRight() && ((Either)((ComponentParameterAst)param.getSecond()).getValueOrResolutionError().getRight()).getRight() instanceof ComponentAst) {
                return this.validate((ComponentAst)((Either)((ComponentParameterAst)param.getSecond()).getValueOrResolutionError().getRight()).getRight(), artifact);
            }
            return Optional.empty();
        }).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private Stream<Pair<ParameterModel, ComponentParameterAst>> requiredParamsStream(ComponentAst component) {
        Stream paramsStream = component.getModel(SourceModel.class).map(sm -> {
            Stream succesCallbackParams = sm.getSuccessCallback().map(scbk -> this.requiredSourceCallbackParameters(component, (SourceCallbackModel)scbk)).orElse(Stream.empty());
            Stream errorCallbackParams = sm.getErrorCallback().map(ecbk -> this.requiredSourceCallbackParameters(component, (SourceCallbackModel)ecbk)).orElse(Stream.empty());
            return Stream.concat(succesCallbackParams, errorCallbackParams);
        }).orElse(Stream.empty());
        return Stream.concat(paramsStream, component.getModel(ParameterizedModel.class).map(pmzd -> ExtensionModelUtils.getGroupAndParametersPairs((ParameterizedModel)pmzd).filter(groupAndParameter -> this.isDoValidation((ParameterModel)groupAndParameter.getSecond())).map(groupAndParameter -> new Pair(groupAndParameter.getSecond(), (Object)component.getParameter(((ParameterGroupModel)groupAndParameter.getFirst()).getName(), ((ParameterModel)groupAndParameter.getSecond()).getName())))).orElse(Stream.empty()));
    }

    private Stream<Pair<ParameterModel, ComponentParameterAst>> requiredSourceCallbackParameters(ComponentAst component, SourceCallbackModel ecbk) {
        return ecbk.getParameterGroupModels().stream().flatMap(cpgm -> cpgm.getParameterModels().stream().filter(this::isDoValidation).map(pm -> new Pair(pm, (Object)component.getParameter(cpgm.getName(), pm.getName()))));
    }

    protected boolean isDoValidation(ParameterModel pm) {
        return pm.isRequired() && !pm.isComponentId();
    }
}

