/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import java.util.List;
import java.util.Optional;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResultItem;
import org.mule.runtime.extension.api.error.ErrorMapping;

public abstract class AbstractErrorTypesValidation
implements Validation {
    protected static final String RAISE_ERROR = "raise-error";
    protected static final String ON_ERROR = "on-error";
    protected static final String ON_ERROR_PROPAGATE = "on-error-propagate";
    protected static final String ON_ERROR_CONTINUE = "on-error-continue";
    protected static final ComponentIdentifier RAISE_ERROR_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("raise-error").build();
    protected static final ComponentIdentifier ON_ERROR_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("on-error").build();
    protected static final ComponentIdentifier ON_ERROR_PROPAGATE_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("on-error-propagate").build();
    protected static final ComponentIdentifier ON_ERROR_CONTINUE_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("on-error-continue").build();

    protected static boolean errorMappingPresent(ComponentAst operationComponent) {
        if (!operationComponent.getModel(ParameterizedModel.class).isPresent()) {
            return false;
        }
        ComponentParameterAst errorMappingsAst = operationComponent.getParameter("Error Mappings", "errorMappings");
        return errorMappingsAst != null && errorMappingsAst.getValue().getValue().isPresent();
    }

    protected static List<ErrorMapping> getErrorMappings(ComponentAst component) {
        return (List)component.getParameter("Error Mappings", "errorMappings").getValue().getRight();
    }

    protected static Optional<ValidationResultItem> validateErrorTypeId(ComponentAst component, ComponentParameterAst parameter, ArtifactAst artifact, Validation validation, String errorTypeString, ComponentIdentifier errorTypeId) {
        Optional errorType = artifact.getErrorTypeRepository().lookupErrorType(errorTypeId);
        if (!errorType.isPresent()) {
            if ("mule".toUpperCase().equals(errorTypeId.getNamespace())) {
                return Optional.of(ValidationResultItem.create((ComponentAst)component, (ComponentParameterAst)parameter, (Validation)validation, (String)String.format("There's no MULE error named '%s'.", errorTypeId.getName())));
            }
            return Optional.of(ValidationResultItem.create((ComponentAst)component, (ComponentParameterAst)parameter, (Validation)validation, (String)String.format("Could not find error '%s'.", errorTypeId.getName())));
        }
        return Optional.empty();
    }

    protected static Optional<ErrorType> lookup(ComponentAst component, String errorTypeParamName, ArtifactAst artifact) {
        return artifact.getErrorTypeRepository().lookupErrorType(AbstractErrorTypesValidation.parserErrorType(component.getParameter("Error Mappings", "type").getResolvedRawValue()));
    }

    protected static ComponentIdentifier parserErrorType(String representation) {
        String identifier;
        String namespace;
        int separator = representation.indexOf(58);
        if (separator > 0) {
            namespace = representation.substring(0, separator).toUpperCase();
            identifier = representation.substring(separator + 1).toUpperCase();
        } else {
            namespace = "mule".toUpperCase();
            identifier = representation.toUpperCase();
        }
        return ComponentIdentifier.builder().name(identifier).namespace(namespace).build();
    }
}

