/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.extension.provider;

import org.apache.commons.lang3.StringUtils;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.declaration.fluent.ComponentDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ConstructDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.NestedChainDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.NestedComponentDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OptionalParameterDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclarer;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.config.internal.dsl.processor.xml.provider.OperationDslNamespaceInfoProvider;
import org.mule.runtime.core.api.extension.provider.MuleExtensionModelProvider;
import org.mule.runtime.core.internal.extension.CustomBuildingDefinitionProviderModelProperty;
import org.mule.runtime.extension.api.ExtensionConstants;
import org.mule.runtime.extension.api.error.ErrorConstants;
import org.mule.runtime.extension.privileged.util.ComponentDeclarationUtils;
import org.mule.sdk.api.stereotype.MuleStereotypes;

public class MuleOperationExtensionModelDeclarer {
    public static final String OPERATION_NAMESPACE = "operation";
    public static final String PARAMETERS = "parameters";
    public static final String PARAMETER = "parameter";
    public static final String OPTIONAL_PARAMETER = "optional-parameter";
    public static final String EXCLUSIVE_OPTIONALS = "exclusive-optionals";
    public static final String TYPE = "type";
    private static final String ALLOW_INLINE_SCRIPT_DESCRIPTION = "Whether the parameter should be able to be defined with an inline script. It could be used for parameters that will contain data for the operation, unlike configuration parameters.";
    private static final String TYPE_EXAMPLE = "string or number or http:request-config";
    private static final MetadataType EXPRESSION_SUPPORT_TYPE = MuleExtensionModelProvider.BASE_TYPE_BUILDER.stringType().enumOf(new String[]{"SUPPORTED", "NOT_SUPPORTED", "REQUIRED"}).build();
    private static final MetadataType PATH_TYPE = MuleExtensionModelProvider.BASE_TYPE_BUILDER.stringType().enumOf(new String[]{"DIRECTORY", "FILE", "ANY"}).build();
    private static final MetadataType PATH_LOCATION_TYPE = MuleExtensionModelProvider.BASE_TYPE_BUILDER.stringType().enumOf(new String[]{"EMBEDDED", "EXTERNAL", "ANY"}).build();
    private static final MetadataType SECRET_TYPE = MuleExtensionModelProvider.BASE_TYPE_BUILDER.stringType().enumOf(new String[]{"CLIENT_ID", "CLIENT_SECRET", "TOKEN_ID", "TOKEN_URL_TEMPLATE", "TOKEN_SECRET", "API_KEY", "SECRET_TOKEN", "SECURITY_TOKEN", "RSA_PRIVATE_KEY", "SECRET"}).build();
    private static final String PARAMETER_DISPLAY_NAME_DESCRIPTION = "Allows to specify a custom label for the element and/or field to be used in the UI. If a value is not specified, the name is inferred from the annotated element's name.";
    private static final String PARAMETER_SUMMARY_NAME_DESCRIPTION = "A very brief overview about the parameter.";
    private static final String PARAMETER_EXAMPLE_DESCRIPTION = "Allows to specify an example for a parameter to be used in the UI. This example is not related to the default value of an optional parameter, it's only for the purpose of showing how does a possible value look like.";
    private static final String PARAMETER_IS_TEXT_DESCRIPTION = "Marks a parameter as one that supports a multi line string input both in the editor (when it is populated from the UI) and in the DSL. This tag should only be used with string parameters.";
    private static final String PARAMETER_SECRET_TYPE_DESCRIPTION = "If present, it indicates the secret type. UI elements accessing the annotated parameter should implement masking. This annotation should only be used with parameters.";
    private static final String PARAMETER_PLACEMENT_ORDER_DESCRIPTION = "Gives the annotated parameter a relative order within its group. The value provided may be repeated and in that case the order is not guaranteed. The value is relative meaning that the element with order 10 is on top than one with value 25.";

    ExtensionDeclarer declareExtensionModel() {
        ExtensionDeclarer declarer = new ExtensionDeclarer().named("Mule Operations DSL").describedAs("DSL for declaring Mule Operation").onVersion(MuleExtensionModelProvider.MULE_VERSION).fromVendor("MuleSoft, Inc.").supportingJavaVersions(ExtensionConstants.ALL_SUPPORTED_JAVA_VERSIONS).withCategory(Category.COMMUNITY).withModelProperty((ModelProperty)new CustomBuildingDefinitionProviderModelProperty()).withXmlDsl(XmlDslModel.builder().setPrefix(OPERATION_NAMESPACE).setNamespace(OperationDslNamespaceInfoProvider.OPERATION_DSL_NAMESPACE_URI).setSchemaVersion(MuleExtensionModelProvider.MULE_VERSION).setXsdFileName("mule-operation.xsd").setSchemaLocation("operation/current/mule-operation.xsd").build());
        this.declareOperationDef(declarer);
        return declarer;
    }

    private void declareOperationDef(ExtensionDeclarer declarer) {
        ConstructDeclarer def = (ConstructDeclarer)((ConstructDeclarer)declarer.withConstruct("def").describedAs("Defines an operation")).allowingTopLevelDefinition().withStereotype(MuleStereotypes.OPERATION_DEF_STEREOTYPE);
        ParameterGroupDeclarer parameters = def.onDefaultParameterGroup();
        parameters.withRequiredParameter("name").describedAs("The operation's name").withDisplayModel(DisplayModel.builder().displayName("Operation name").summary("The operation's name").build()).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED).ofType(MuleExtensionModelProvider.STRING_TYPE).asComponentId();
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)parameters.withOptionalParameter("description").ofType(MuleExtensionModelProvider.STRING_TYPE)).describedAs("Detailed description of the operation purpose and behavior")).withDisplayModel(DisplayModel.builder().displayName("Description").summary("Detailed description of the operation purpose and behavior").build())).ofType(MuleExtensionModelProvider.STRING_TYPE)).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).withLayout(LayoutModel.builder().asText().build());
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)parameters.withOptionalParameter("summary").ofType(MuleExtensionModelProvider.STRING_TYPE)).describedAs("A brief description of the operation")).withDisplayModel(DisplayModel.builder().displayName("Summary").summary("A brief description of the operation").build())).ofType(MuleExtensionModelProvider.STRING_TYPE)).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)parameters.withOptionalParameter("displayName").ofType(MuleExtensionModelProvider.STRING_TYPE)).describedAs("The operation's name in the GUI")).withDisplayModel(DisplayModel.builder().displayName("Display Name").summary("The operation's name in the GUI").build());
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)parameters.withOptionalParameter("visibility").ofType((MetadataType)MuleExtensionModelProvider.BASE_TYPE_BUILDER.stringType().enumOf(new String[]{"PUBLIC", "PRIVATE"}).build())).describedAs("The operation visibility to third parties")).withDisplayModel(DisplayModel.builder().displayName("Visibility").summary("The operation visibility to third parties").build());
        this.addParametersDeclaration(def);
        this.declareOutputConstruct(def);
        this.declareDeprecationConstruct((ComponentDeclarer)def, "Defines an operation's deprecation.");
        ((NestedChainDeclarer)def.withChain("body").describedAs("The operations that makes for the operation's implementation")).setRequired(true);
        this.declareRaiseError(declarer);
    }

    private void declareOutputConstruct(ConstructDeclarer def) {
        NestedComponentDeclarer outputConstruct = def.withComponent("output").describedAs("Defines a operation's output types.").withStereotype(MuleStereotypes.OUTPUT_STEREOTYPE).withMinOccurs(1).withMaxOccurs(Integer.valueOf(1));
        NestedComponentDeclarer payloadType = outputConstruct.withComponent("payload-type").describedAs("Type definition for the operation's output payload").withStereotype(MuleStereotypes.OUTPUT_PAYLOAD_STEREOTYPE).withMinOccurs(1).withMaxOccurs(Integer.valueOf(1));
        this.declareOutputTypeParameters(payloadType, "payload");
        NestedComponentDeclarer attributesType = outputConstruct.withOptionalComponent("attributes-type").describedAs("Type definition for the operation's output attributes").withStereotype(MuleStereotypes.OUTPUT_ATTRIBUTES_STEREOTYPE).withMinOccurs(0).withMaxOccurs(Integer.valueOf(1));
        this.declareOutputTypeParameters(attributesType, "attributes");
    }

    private void declareDeprecationConstruct(ComponentDeclarer def, String description) {
        NestedComponentDeclarer deprecationConstruct = def.withComponent("deprecated").describedAs(description).withStereotype(MuleStereotypes.DEPRECATED_STEREOTYPE).withMinOccurs(0).withMaxOccurs(Integer.valueOf(1));
        ParameterGroupDeclarer defaultParameterGroupDeclarer = deprecationConstruct.onDefaultParameterGroup();
        defaultParameterGroupDeclarer.withRequiredParameter("message").describedAs("Describes why something was deprecated, what can be used as substitute, or both").ofType(MuleExtensionModelProvider.STRING_TYPE).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
        defaultParameterGroupDeclarer.withRequiredParameter("since").describedAs("The version of the extension in which the annotated member was deprecated").ofType(MuleExtensionModelProvider.STRING_TYPE).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)defaultParameterGroupDeclarer.withOptionalParameter("toRemoveIn").describedAs("The version of the extension in which the annotated member will be removed or was removed")).ofType(MuleExtensionModelProvider.STRING_TYPE)).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
    }

    private void declareRaiseError(ExtensionDeclarer extensionDeclarer) {
        OperationDeclarer raiseError = (OperationDeclarer)extensionDeclarer.withOperation("raiseError").describedAs("Throws an error with the specified type and description.");
        ComponentDeclarationUtils.withNoErrorMapping((OperationDeclarer)raiseError);
        raiseError.withOutput().ofType(MuleExtensionModelProvider.VOID_TYPE);
        raiseError.withOutputAttributes().ofType(MuleExtensionModelProvider.VOID_TYPE);
        ParameterGroupDeclarer parameters = raiseError.onDefaultParameterGroup();
        parameters.withRequiredParameter(TYPE).ofType(ErrorConstants.ERROR_TYPE_DEFINITION).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED).describedAs("The error type to raise.");
        ((OptionalParameterDeclarer)parameters.withOptionalParameter("description").ofType(MuleExtensionModelProvider.STRING_TYPE)).describedAs("The description of this error.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)parameters.withOptionalParameter("cause").ofType(ErrorConstants.ERROR)).withExpressionSupport(ExpressionSupport.SUPPORTED)).defaultingTo((Object)"#[error]").describedAs("The cause of the error.");
    }

    private void declareOutputTypeParameters(NestedComponentDeclarer component, String outputRole) {
        component.onDefaultParameterGroup().withRequiredParameter(TYPE).describedAs("The output " + outputRole + " type").withDisplayModel(DisplayModel.builder().displayName(StringUtils.capitalize((String)outputRole) + " type").summary("The output " + outputRole + " type").example(TYPE_EXAMPLE).build()).ofType(MuleExtensionModelProvider.STRING_TYPE).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
    }

    private DisplayModel display(String displayName, String summary) {
        return DisplayModel.builder().displayName(displayName).summary(summary).build();
    }

    private DisplayModel display(String displayName, String summary, String example) {
        return DisplayModel.builder().displayName(displayName).summary(summary).example(example).build();
    }

    private void addParametersDeclaration(ConstructDeclarer def) {
        NestedComponentDeclarer parametersDef = def.withOptionalComponent(PARAMETERS).describedAs("The operation's parameters").withMinOccurs(0).withMaxOccurs(Integer.valueOf(1));
        NestedComponentDeclarer parameterDef = parametersDef.withComponent(PARAMETER).describedAs("Defines an operation parameter").withMinOccurs(0).withMaxOccurs(null);
        this.declareDeprecationConstruct((ComponentDeclarer)parameterDef, "Defines a parameter's deprecation.");
        this.addParameterDeclaration((ComponentDeclarer)parameterDef);
        NestedComponentDeclarer optionalParameterDef = parametersDef.withOptionalComponent(OPTIONAL_PARAMETER).describedAs("Defines an optional operation parameter").withMinOccurs(0).withMaxOccurs(null);
        this.addOptionalParameterDeclaration((ComponentDeclarer)optionalParameterDef);
        NestedComponentDeclarer exclusiveOptionalDef = parametersDef.withOptionalComponent(EXCLUSIVE_OPTIONALS).describedAs("Defines a set of mutually exclusive parameters").withMinOccurs(0).withMaxOccurs(Integer.valueOf(1));
        exclusiveOptionalDef.onDefaultParameterGroup().withRequiredParameter("exclusiveOptionals").describedAs("Comma separated list of parameters that are mutually exclusive").ofType(MuleExtensionModelProvider.STRING_TYPE).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED).withDisplayModel(this.display("Parameters", "Comma separated list of parameters that this element is optional against"));
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)exclusiveOptionalDef.onDefaultParameterGroup().withOptionalParameter("oneRequired").describedAs("Enforces that one of the parameters must be set at any given time")).ofType(MuleExtensionModelProvider.BOOLEAN_TYPE)).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).withDisplayModel(this.display("One required?", "Enforces that one of the parameters must be set at any given time"));
    }

    private void addParameterDeclaration(ComponentDeclarer parameterDef) {
        ParameterGroupDeclarer parameterGroupDeclarer = parameterDef.onDefaultParameterGroup();
        parameterGroupDeclarer.withRequiredParameter("name").describedAs("The parameter's name").ofType(MuleExtensionModelProvider.STRING_TYPE).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED).withDisplayModel(this.display("Parameter name", "The parameter's name"));
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)parameterGroupDeclarer.withOptionalParameter("description").describedAs("Detailed description of the parameter, it's semantics, usage and effects")).ofType(MuleExtensionModelProvider.STRING_TYPE)).withDisplayModel(this.display("Parameter description", "Detailed description of the parameter, it's semantics, usage and effects"))).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).withLayout(LayoutModel.builder().asText().build());
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)parameterGroupDeclarer.withOptionalParameter(TYPE).describedAs("The parameter's type")).ofType(MuleExtensionModelProvider.STRING_TYPE)).withDisplayModel(this.display("Parameter type", "The Parameter's type", TYPE_EXAMPLE))).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)parameterGroupDeclarer.withOptionalParameter("expressionSupport").describedAs("The support level this parameter offers regarding expressions")).ofType(EXPRESSION_SUPPORT_TYPE)).defaultingTo((Object)ExpressionSupport.SUPPORTED.name()).withDisplayModel(this.display("Expression Support", "The support level this parameter offers regarding expressions"))).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)parameterGroupDeclarer.withOptionalParameter("allowInlineScript").describedAs(ALLOW_INLINE_SCRIPT_DESCRIPTION)).ofType(MuleExtensionModelProvider.BOOLEAN_TYPE)).defaultingTo((Object)"false").withDisplayModel(this.display("Allow Inline Script", ALLOW_INLINE_SCRIPT_DESCRIPTION))).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)parameterGroupDeclarer.withOptionalParameter("configOverride").describedAs("Whether the parameter should act as a Config Override.")).ofType(MuleExtensionModelProvider.BOOLEAN_TYPE)).defaultingTo((Object)"false").withDisplayModel(this.display("Config Override", "Whether the parameter should act as a Config Override."))).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
        this.addParameterLayoutDeclaration(parameterDef);
    }

    private void addParameterLayoutDeclaration(ComponentDeclarer parameterDef) {
        NestedComponentDeclarer parameterMetadataDef = parameterDef.withOptionalComponent("parameter-metadata").describedAs("Parameter metadata including display and layout information");
        ParameterGroupDeclarer parameterMetadataAttributes = parameterMetadataDef.onDefaultParameterGroup();
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)parameterMetadataAttributes.withOptionalParameter("displayName").describedAs(PARAMETER_DISPLAY_NAME_DESCRIPTION)).ofType(MuleExtensionModelProvider.STRING_TYPE)).withDisplayModel(this.display("Display Name", PARAMETER_DISPLAY_NAME_DESCRIPTION))).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)parameterMetadataAttributes.withOptionalParameter("summary").describedAs(PARAMETER_SUMMARY_NAME_DESCRIPTION)).ofType(MuleExtensionModelProvider.STRING_TYPE)).withDisplayModel(this.display("Summary", PARAMETER_SUMMARY_NAME_DESCRIPTION))).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)parameterMetadataAttributes.withOptionalParameter("example").describedAs(PARAMETER_EXAMPLE_DESCRIPTION)).ofType(MuleExtensionModelProvider.STRING_TYPE)).withDisplayModel(this.display("Example", PARAMETER_EXAMPLE_DESCRIPTION))).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)parameterMetadataAttributes.withOptionalParameter("text").describedAs(PARAMETER_IS_TEXT_DESCRIPTION)).ofType(MuleExtensionModelProvider.BOOLEAN_TYPE)).withDisplayModel(this.display("Text", PARAMETER_IS_TEXT_DESCRIPTION))).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)parameterMetadataAttributes.withOptionalParameter("secret").describedAs(PARAMETER_SECRET_TYPE_DESCRIPTION)).ofType(SECRET_TYPE)).withDisplayModel(this.display("Secret", PARAMETER_SECRET_TYPE_DESCRIPTION))).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)parameterMetadataAttributes.withOptionalParameter("order").describedAs(PARAMETER_PLACEMENT_ORDER_DESCRIPTION)).ofType(MuleExtensionModelProvider.INTEGER_TYPE)).withDisplayModel(this.display("Placement Order", PARAMETER_PLACEMENT_ORDER_DESCRIPTION))).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
        this.addPathDeclaration((ComponentDeclarer)parameterMetadataDef);
    }

    private void addPathDeclaration(ComponentDeclarer parameterMetadataDef) {
        NestedComponentDeclarer pathDef = parameterMetadataDef.withOptionalComponent("path").describedAs("Marks parameter as a path to a file or directory. This tag should only be used with string parameters.");
        ParameterGroupDeclarer pathAttributes = pathDef.onDefaultParameterGroup();
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)pathAttributes.withOptionalParameter(TYPE).describedAs("Whether the path is to a directory or a file. The possible values are DIRECTORY, FILE, and ANY.")).ofType(PATH_TYPE)).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)pathAttributes.withOptionalParameter("acceptsUrls").describedAs("Whether the path parameter also supports urls.")).ofType(MuleExtensionModelProvider.BOOLEAN_TYPE)).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)pathAttributes.withOptionalParameter("location").describedAs("A classifier for the path's generic location. The possible values are EMBEDDED, EXTERNAL, and ANY.")).ofType(PATH_LOCATION_TYPE)).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)pathAttributes.withOptionalParameter("acceptedFileExtensions").describedAs("Comma separated enumeration of the file extensions that this path handles. Only valid when the path type isn't a DIRECTORY")).ofType(MuleExtensionModelProvider.STRING_TYPE)).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
    }

    private void addOptionalParameterDeclaration(ComponentDeclarer parameterDef) {
        this.addParameterDeclaration(parameterDef);
        ParameterGroupDeclarer parameterGroupDeclarer = parameterDef.onDefaultParameterGroup();
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)parameterGroupDeclarer.withOptionalParameter("defaultValue").describedAs("The parameter's default value if not provided.")).ofType(MuleExtensionModelProvider.STRING_TYPE)).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).withDisplayModel(this.display("Optional", "The parameter's default value if not provided."));
    }
}

